# HealthcareServiceLocation - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **HealthcareServiceLocation**

## ValueSet: HealthcareServiceLocation 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/ValueSet/v3-HealthcareServiceLocation | *Version*:4.0.0 | |
| Active as of 2014-03-26 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:HealthcareServiceLocation |
| *Other Identifiers:*OID:2.16.840.1.113883.1.11.20275 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
A comprehensive classification of locations and settings where healthcare services are provided. This value set is based on the CMS Place of Service code set NHSN location code system that has been developed over a number of years through CDCaTMs interaction with a variety of healthcare facilities and is intended to serve a variety of reporting needs where coding of healthcare service locations is required. Excluded codes are those that do not represent an actual location where health care services can be delivered, IE: Float, or a location aggregation. 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

 

### Expansion

No Expansion for this valueset (not supported by Publication Tooling)

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "v3-HealthcareServiceLocation",
  "language" : "en",
  "url" : "http://terminology.hl7.org/ValueSet/v3-HealthcareServiceLocation",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.1.11.20275"
    }
  ],
  "version" : "4.0.0",
  "name" : "HealthcareServiceLocation",
  "title" : "HealthcareServiceLocation",
  "status" : "active",
  "experimental" : false,
  "date" : "2014-03-26",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "A comprehensive classification of locations and settings where healthcare services are provided. This value set is based on the CMS Place of Service code set NHSN location code system that has been developed over a number of years through CDCaTMs interaction with a variety of healthcare facilities and is intended to serve a variety of reporting needs where coding of healthcare service locations is required.  Excluded codes are those that do not represent an actual location where health care services can be delivered, IE: Float, or a location aggregation.",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "compose" : {
    "include" : [
      {
        "system" : "https://www.cdc.gov/nhsn/cdaportal/terminology/codesystem/hsloc.html"
      },
      {
        "system" : "https://www.cms.gov/Medicare/Coding/place-of-service-codes/Place_of_Service_Code_Set"
      }
    ],
    "exclude" : [
      {
        "system" : "https://www.cdc.gov/nhsn/cdaportal/terminology/codesystem/hsloc.html",
        "concept" : [
          {
            "code" : "1206-2"
          },
          {
            "code" : "1250-0"
          },
          {
            "code" : "1251-8"
          }
        ]
      }
    ]
  }
}

```
