# MIF concept relationship kind - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **MIF concept relationship kind**

## Extension: MIF concept relationship kind 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-relationshipKind | *Version*:0.0.34 |
| Active as of 2025-12-11 | *Computable Name*:SupportedConceptRelationshipRelationshipKind |

Identifies a type of relationship between codes that is supported by this code system version

**Context of Use**

**Usage info**

**Usages:**

* Examples for this Extension: [ActCode](CodeSystem-v3-ActCode.md), [AddressPartType](CodeSystem-v3-AddressPartType.md), [EntityCode](CodeSystem-v3-EntityCode.md), [EntityNamePartTypeR2](CodeSystem-v3-EntityNamePartTypeR2.md)...Show 5 more,[MessageWaitingPriority](CodeSystem-v3-MessageWaitingPriority.md),[RoleCode](CodeSystem-v3-RoleCode.md),[Hl7PublishingDomain](CodeSystem-v3-hl7PublishingDomain.md),[Hl7PublishingSubSection](CodeSystem-v3-hl7PublishingSubSection.md)and[Hl7Realm](CodeSystem-v3-hl7Realm.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.terminology|current/StructureDefinition/ext-mif-relationship-relationshipKind)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ext-mif-relationship-relationshipKind.csv), [Excel](StructureDefinition-ext-mif-relationship-relationshipKind.xlsx), [Schematron](StructureDefinition-ext-mif-relationship-relationshipKind.sch) 

#### Terminology Bindings

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ext-mif-relationship-relationshipKind",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-type-characteristics",
      "valueCode" : "can-bind"
    }
  ],
  "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-relationshipKind",
  "version" : "0.0.34",
  "name" : "SupportedConceptRelationshipRelationshipKind",
  "title" : "MIF concept relationship kind",
  "status" : "active",
  "date" : "2025-12-11T21:56:12-07:00",
  "description" : "Identifies a type of relationship between codes that is supported by this code system version",
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "mif",
      "uri" : "urn:hl7-org:v3/mif2",
      "name" : "HL7 V3 Model Interchange Format 2"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "CodeSystem.property"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "MIF concept relationship kind",
        "definition" : "Identifies a type of relationship between codes that is supported by this code system version",
        "max" : "1"
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "type" : [
          {
            "code" : "uri"
          }
        ],
        "fixedUri" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-relationshipKind"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://terminology.hl7.org/ValueSet/mif-conceptRelationshipKind"
        },
        "mapping" : [
          {
            "identity" : "mif",
            "map" : "SupportedConceptRelationship.relationshipKind"
          }
        ]
      }
    ]
  }
}

```
