# Active Ingredient Code - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Active Ingredient Code**

## NamingSystem: Active Ingredient Code 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/v3-hc-aic | *Version*:3.0.0 | |
| Active as of 2021-03-22 | *Responsible:*Health Canada | *Computable Name*:HcAIC |

 
Foreign key for the Active Ingredient Table that relates active ingredients to specific products. 
Further information about this Code System can be found at https://www.canada.ca/en/health-canada/services/drugs-health-products/drug-products/drug-product-database/read-file-drug-product-database-data-extract.htmll 



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "v3-hc-aic",
  "url" : "http://terminology.hl7.org/NamingSystem/v3-hc-aic",
  "version" : "3.0.0",
  "name" : "HcAIC",
  "title" : "Active Ingredient Code",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2021-03-22T00:00:00-04:00",
  "publisher" : "Health Canada",
  "contact" : [
    {
      "name" : "Health Canada"
    }
  ],
  "responsible" : "HL7 Canada",
  "description" : "Foreign key for the Active Ingredient Table that relates active ingredients to specific products.  \r\n\r\nFurther information about this Code System can be found at https://www.canada.ca/en/health-canada/services/drugs-health-products/drug-products/drug-product-database/read-file-drug-product-database-data-extract.htmll",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.5.1103",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/v3-hc-aic",
      "preferred" : true,
      "comment" : "Official canonical URL going forward.",
      "period" : {
        "start" : "2021-03-22"
      }
    },
    {
      "type" : "uri",
      "value" : "http://www.canada.ca/en/health-canada/services/drugs-health-products/drug-products/drug-product-database-1",
      "preferred" : false,
      "comment" : "Maintained for backward compatibility."
    }
  ]
}

```
