# ProcedureMethod - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ProcedureMethod**

## NamingSystem: ProcedureMethod 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/v3-ProcedureMethod | *Version*:3.0.0 | |
| Retired as of 2019-03-20 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ProcedureMethod |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Identifies the technique used to perform a procedure. 



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "v3-ProcedureMethod",
  "url" : "http://terminology.hl7.org/NamingSystem/v3-ProcedureMethod",
  "version" : "3.0.0",
  "name" : "ProcedureMethod",
  "title" : "ProcedureMethod",
  "status" : "retired",
  "kind" : "codesystem",
  "date" : "2019-03-20T00:00:00-04:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "responsible" : "Health Level 7",
  "description" : "Identifies the technique used to perform a procedure.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.5.1065",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/v3-ProcedureMethod",
      "preferred" : true
    }
  ]
}

```
