# United States Social Security Number - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **United States Social Security Number**

## NamingSystem: United States Social Security Number 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/ssn | *Version*:1.0.0 |
| Active as of 2022-02-07 | *Computable Name*:SSN |

 
United States Social Security Number (SSN). Assigned by the U.S. Social Security Administration. Note: IRS assigned ITINs are often used as drop-ins for social security numbers. The SSN is represented in resources with dashes removed. See http://www.ssa.gov/. 



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "ssn",
  "url" : "http://terminology.hl7.org/NamingSystem/ssn",
  "version" : "1.0.0",
  "name" : "SSN",
  "title" : "United States Social Security Number",
  "status" : "active",
  "kind" : "identifier",
  "date" : "2022-02-07T00:00:00-00:00",
  "type" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
        "code" : "SB"
      }
    ]
  },
  "description" : "United States Social Security Number (SSN).  Assigned by the U.S. Social Security Administration.  Note: IRS assigned ITINs are often used as drop-ins for social security numbers.  The SSN is represented in resources with dashes removed. See http://www.ssa.gov/.",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.4.1",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://hl7.org/fhir/sid/us-ssn",
      "preferred" : true
    }
  ]
}

```
