# CMS Present on Admission (POA) Indicator - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **CMS Present on Admission (POA) Indicator**

## NamingSystem: CMS Present on Admission (POA) Indicator 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/presentOnAdmission | *Version*:1.0.0 |
| Active as of 2021-01-07 | *Responsible:*Centers for Medicare & Medicaid Services /td>*Realm:*![](assets/images/usa.svg)*Computable Name*:PresentOnAdmission**Copyright/Legal**: The POA Indicator Codes are in the public domain and are free to use without restriction.This code system consists of Present on Admission (POA) indicators which are assigned to the principal and secondary diagnoses (as defined in Section II of the Official Guidelines for Coding and Reporting) and the external cause of injury codes to indicate the presence or absence of the diagnosis at the time of inpatient admission. |



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "presentOnAdmission",
  "url" : "http://terminology.hl7.org/NamingSystem/presentOnAdmission",
  "version" : "1.0.0",
  "name" : "PresentOnAdmission",
  "title" : "CMS Present on Admission (POA) Indicator",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2021-01-07T00:00:00.000-07:00",
  "publisher" : "Centers for Medicare & Medicaid Services",
  "contact" : [
    {
      "name" : "Centers for Medicare & Medicaid Services"
    },
    {
      "name" : "Marilu Hue",
      "telecom" : [
        {
          "system" : "email",
          "value" : "marilu.hue@cms.hhs.gov"
        }
      ]
    },
    {
      "name" : "James Poyer",
      "telecom" : [
        {
          "system" : "email",
          "value" : "james.poyer@cms.hhs.gov"
        }
      ]
    }
  ],
  "description" : "This code system consists of Present on Admission (POA) indicators which are assigned to the principal and secondary diagnoses (as defined in Section II of the Official Guidelines for Coding and Reporting) and the external cause of injury codes to indicate the presence or absence of the diagnosis at the time of inpatient admission.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "copyright" : "The POA Indicator Codes are in the public domain and are free to use without restriction.",
  "uniqueId" : [
    {
      "type" : "uri",
      "value" : "https://www.cms.gov/Medicare/Medicare-Fee-for-Service-Payment/HospitalAcqCond/Coding",
      "preferred" : true
    },
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.6.301.11",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "https://www.nubc.org/CodeSystem/PresentOnAdmissionIndicator",
      "comment" : "The uri created for this code system by the CARIN project"
    },
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/v2-0895",
      "comment" : "The v2 table of present on admission indicators."
    }
  ]
}

```
