# International Classification of Diseases, 10th Revision, Clinical Modification (ICD-10-CM) - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **International Classification of Diseases, 10th Revision, Clinical Modification (ICD-10-CM)**

## NamingSystem: International Classification of Diseases, 10th Revision, Clinical Modification (ICD-10-CM) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/icd10CM | *Version*:2.2.1 | |
| Active as of 2021-02-16 | *Responsible:*NCHS | *Computable Name*:Icd10CM |

 
The International Classification of Diseases, 10th Revision, Clinical Modification (ICD-10-CM), describes the classification of morbidity and mortality information for statistical purposes and for the indexing of healthcare records by diseases. The ICD-10-CM codes can be used as the value of the Act.cd attribute. 



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "icd10CM",
  "url" : "http://terminology.hl7.org/NamingSystem/icd10CM",
  "version" : "2.2.1",
  "name" : "Icd10CM",
  "title" : "International Classification of Diseases, 10th Revision, Clinical Modification (ICD-10-CM)",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2021-02-16T00:00:00-04:00",
  "publisher" : "NCHS",
  "contact" : [
    {
      "name" : "National Center for Health Statistics/Centers for Disease Control and Prevention"
    }
  ],
  "responsible" : "NCHS",
  "description" : "The International Classification of Diseases, 10th Revision, Clinical Modification (ICD-10-CM), describes the classification of morbidity and mortality information for statistical purposes and for the indexing of healthcare records by diseases. The ICD-10-CM codes can be used as the value of the Act.cd attribute.",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.6.90",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/icd10CM",
      "preferred" : false,
      "comment" : "Published for many years in HL7 Standards, but has now been superceded.   Retained here for backwards-compatibility and convenience."
    },
    {
      "type" : "uri",
      "value" : "http://hl7.org/fhir/sid/icd-10-cm",
      "preferred" : true,
      "comment" : "This is the URL as specified by the terminology owner, and is considereed authoritative."
    }
  ]
}

```
