# Medicare Beneficiary Identifier (United States) - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Medicare Beneficiary Identifier (United States)**

## NamingSystem: Medicare Beneficiary Identifier (United States) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/cmsMBI | *Version*:1.0.0 | |
| Active as of 2022-02-07 | *Responsible:*Center for Medicare and Medicaid Services (CMS) | *Computable Name*:CmsMBI |

 
Medicare Beneficiary Identifier (MBI) number is a unique identifier of a beneficiary used for Medicare entitlement and billing purposes. Medicare Beneficiary Identifiers are represented without any spaces or dashes. 



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "cmsMBI",
  "url" : "http://terminology.hl7.org/NamingSystem/cmsMBI",
  "version" : "1.0.0",
  "name" : "CmsMBI",
  "title" : "Medicare Beneficiary Identifier (United States)",
  "status" : "active",
  "kind" : "identifier",
  "date" : "2022-02-07T00:00:00-00:00",
  "publisher" : "Center for Medicare and Medicaid Services (CMS)",
  "type" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
        "code" : "SB"
      }
    ]
  },
  "description" : "Medicare Beneficiary Identifier (MBI) number is a unique identifier of a beneficiary used for Medicare entitlement and billing purposes. Medicare Beneficiary Identifiers are represented without any spaces or dashes.",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.4.927",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://hl7.org/fhir/sid/us-mbi",
      "preferred" : true
    }
  ]
}

```
