# Bluetooth Address as a device identifier - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Bluetooth Address as a device identifier**

## NamingSystem: Bluetooth Address as a device identifier 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/bluetooth-address-identifier | *Version*:1.0.0 | |
| Active as of 2021-06-14 | *Responsible:*IHE Patient Care Devices (PCD) | *Computable Name*:Bluetooth_Address_Identifier |

 
The Bluetooth Device Address (sometimes referred to as a Bluetooth MAC address) is a unique 48-bit identifier assigned to each Bluetooth device by the manufacturer. Bluetooth Addresses are usually displayed as 6 bytes written in hexadecimal and separated by colons (example - 00:11:22:33:FF:EE). They are an essential part of Bluetooth-based protocols. The upper half of a Bluetooth Address (most-significant 24 bits) is the so-called Organizationally Unique Identifier (OUI). It can be used to determine the manufacturer of a device (Bluetooth MAC Address Lookup form). OUI prefixes are assigned by the Institute of Electrical and Electronics Engineers (IEEE). An EUI (Extended Unique Identifier) is generally made from an OUI and thus a Bluetooth Address is also an EUI-48. A device that has a Bluetooth address can also have it own Ethernet MAC address. 



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "bluetooth-address-identifier",
  "url" : "http://terminology.hl7.org/NamingSystem/bluetooth-address-identifier",
  "version" : "1.0.0",
  "name" : "Bluetooth_Address_Identifier",
  "title" : "Bluetooth Address as a device identifier",
  "status" : "active",
  "kind" : "identifier",
  "date" : "2021-06-14T00:00:00-00:00",
  "publisher" : "IHE Patient Care Devices (PCD)",
  "contact" : [
    {
      "name" : "Devices on FHIR working group; IHE Patient Care Devices"
    }
  ],
  "responsible" : "IHE Patient Care Devices",
  "description" : "The Bluetooth Device Address (sometimes referred to as a Bluetooth MAC address) is a unique 48-bit identifier assigned to each Bluetooth device by the manufacturer. Bluetooth Addresses are usually displayed as 6 bytes written in hexadecimal and separated by colons (example - 00:11:22:33:FF:EE). They are an essential part of Bluetooth-based protocols. The upper half of a Bluetooth Address (most-significant 24 bits) is the so-called Organizationally Unique Identifier (OUI). It can be used to determine the manufacturer of a device (Bluetooth MAC Address Lookup form). OUI prefixes are assigned by the Institute of Electrical and Electronics Engineers (IEEE). An EUI (Extended Unique Identifier) is generally made from an OUI and thus a Bluetooth Address is also an EUI-48. A device that has a Bluetooth address can also have it own Ethernet MAC address.",
  "uniqueId" : [
    {
      "type" : "uri",
      "value" : "http://hl7.org/fhir/sid/eui-48/bluetooth",
      "preferred" : true,
      "comment" : "Bluetooth EUI-48 address"
    }
  ]
}

```
