# X12 Service Type Codes - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **X12 Service Type Codes**

## NamingSystem: X12 Service Type Codes 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/X12ServiceTypeCodes | *Version*:1.0.0 | |
| Active as of 2023-06-14 | *Responsible:*[Washington Publishing Company (WPC)](https://x12.org/index.php/resources/contact-us) | *Computable Name*:X12ServiceTypeCodes |
| **Copyright/Legal**: All X12 work products are copyrighted. Any use of any X12 work product must be compliant with US Copyright laws and X12 Intellectual Property policies.Please see[https://x12.org/products/licensing-program](https://x12.org/products/licensing-program) | | |

 
"X12, chartered by the American National Standards Institute for more than 40 years, develops and maintains EDI standards and XML schemas which drive business processes globally. X12's diverse membership includes technologists and business process experts in health care, insurance, transportation, finance, government, supply chain and other industries." 
The X12 Service Type Codes identify business groupings for health care services or benefits. These codes are listed within an X12 implementation guide (TR3) and maintained by X12. 
External code lists maintained by X12 and external code lists maintained by others and distributed by WPC on behalf of the maintainer can be found here:[https://x12.org/codes](https://x12.org/codes) 
Click on the name of any external code list to access more information about the code list, view the codes, or submit a maintenance request. These external code lists were previously published on either[http://www.wpc-edi.com/reference](http://www.wpc-edi.com/reference)or[http://www.x12.org/codes](http://www.x12.org/codes). 
If you have questions about these lists, submit them on the[X12 Feedback form](https://x12.org/resources/feedback). 
"All X12 products are subject to this IP policy, including published and draft works. 
X12 is the only organization authorized to grant permission for use of X12 products. Users of all X12 products should make sure that they understand the permissible uses, as well as the limitations on such usage, as outlined below." 
Additional IP information can be found here:[https://x12.org/products/ip-use](https://x12.org/products/ip-use) 
"Send an email to[ip@x12.org](mailto:ip@x12.org)to request permission to reproduce X12 IP. Include your name, organization, title, address, city, state, zip, email, a detailed description of the Submitted Artifact, including the underlying or cited X12 Product, and a detailed description of the intended audience and planned distribution method for the Artifact." 
Additional information on X12 licensing program can be found here:[https://x12.org/products/licensing-program](https://x12.org/products/licensing-program) 
To purchase code list subscriptions call (425) 562-2245 or email[admin@wpc-edi.com](mailto:admin@wpc-edi.com). 



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "X12ServiceTypeCodes",
  "url" : "http://terminology.hl7.org/NamingSystem/X12ServiceTypeCodes",
  "version" : "1.0.0",
  "name" : "X12ServiceTypeCodes",
  "title" : "X12 Service Type Codes",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2023-06-14T00:00:00-00:00",
  "publisher" : "Washington Publishing Company (WPC)",
  "contact" : [
    {
      "name" : "X12; 1405 S Fern St #92957; Arlington, Virginia 22202",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://x12.org/index.php/resources/contact-us"
        },
        {
          "system" : "phone",
          "value" : "703.970.4480"
        }
      ]
    }
  ],
  "responsible" : "X12-03/CX12-03/CMG01 Transitional Code",
  "description" : "\"X12, chartered by the American National Standards Institute for more than 40 years, develops and maintains EDI standards and XML schemas which drive business processes globally. X12's diverse membership includes technologists and business process experts in health care, insurance, transportation, finance, government, supply chain and other industries.\"\r\n\r\nThe X12 Service Type Codes identify business groupings for health care services or benefits. These codes are listed within an X12 implementation guide (TR3) and maintained by X12.\r\n\r\nExternal code lists maintained by X12 and external code lists maintained by others and distributed by WPC on behalf of the maintainer can be found here: [https://x12.org/codes](https://x12.org/codes)\r\n\r\nClick on the name of any external code list to access more information about the code list, view the codes, or submit a maintenance request. These external code lists were previously published on either [http://www.wpc-edi.com/reference](http://www.wpc-edi.com/reference) or [http://www.x12.org/codes](http://www.x12.org/codes).\r\n\r\nIf you have questions about these lists, submit them on the [X12 Feedback form](https://x12.org/resources/feedback).\r\n\r\n\"All X12 products are subject to this IP policy, including published and draft works.\r\n\r\nX12 is the only organization authorized to grant permission for use of X12 products. Users of all X12 products should make sure that they understand the permissible uses, as well as the limitations on such usage, as outlined below.\"\r\n\r\nAdditional IP information can be found here: [https://x12.org/products/ip-use](https://x12.org/products/ip-use)\r\n\r\n\"Send an email to [ip@x12.org](mailto:ip@x12.org) to request permission to reproduce X12 IP. Include your name, organization, title, address, city, state, zip, email, a detailed description of the Submitted Artifact, including the underlying or cited X12 Product, and a detailed description of the intended audience and planned distribution method for the Artifact.\"\r\n\r\nAdditional information on X12 licensing program can be found here: [https://x12.org/products/licensing-program](https://x12.org/products/licensing-program)\r\n\r\nTo purchase code list subscriptions call (425) 562-2245 or email [admin@wpc-edi.com](mailto:admin@wpc-edi.com).",
  "copyright" : "All X12 work products are copyrighted. Any use of any X12 work product must be compliant with US Copyright laws and X12 Intellectual Property policies.\r\n\r\nPlease see [https://x12.org/products/licensing-program](https://x12.org/products/licensing-program)",
  "uniqueId" : [
    {
      "type" : "uri",
      "value" : "https://x12.org/codes/service-type-codes",
      "preferred" : true,
      "comment" : "This is the URL as specified by the terminology owner, and is considered authoritative.",
      "period" : {
        "start" : "2023-06-15"
      }
    }
  ]
}

```
