# TNM Staging System - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **TNM Staging System**

## NamingSystem: TNM Staging System 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/TNM | *Version*:1.0.0 | |
| Active as of 2022-01-14 | *Responsible:*[American Joint Committee on Cancer](https://cancerstaging.org/) | *Computable Name*:TNM |
| **Copyright/Legal**: The AJCC may grant permission for use of copyrighted material from the AJCC Cancer Staging Manual to outside individuals and organizations at its own discretion. No changes to, additions to, or deletions from the copied or reused material should be made without prior written approval of the AJCC. Permission applies only to the material and use specified in correspondence. New requests should be made for subsequent use or for other uses of material.To license AJCC content for commercial use in electronic health record (EHR) systems or other software and applications, please email ajcc@facs.org for more information on licensing our API.To request permission to photocopy, duplicate, republish, or otherwise reuse AJCC material in journals, presentations or course material, follow the instructions below.For Sixth, Seventh, Eighth Editions please contact bookpermissions@springernature.com.For Fifth Edition please contact the publisher at healthpermissions@wolterskluwer.com.Please note that some items in the manual are reproduced with permission from other rights holders. If you wish to reproduce any of those items, you must request permission from the original rights holders. This is often possible through www.copyright.com. | | |

 
The TNM Staging System was developed and is maintained by the AJCC and the Union for International Cancer Control (UICC). It is the most commonly used staging system by medical professionals around the world. The TNM classification system was developed as a tool for doctors to stage different types of cancer based on certain, standardized criteria. The TNM Staging System is based on the extent of the tumor (T), the extent of spread to the lymph nodes (N), and the presence of metastasis (M). 
HTA Note: Most content of TNM (V6) is in the SNOMED international release but not content from the most recent (V9). In Europe many countries use TNM codes, taken from the book and referenced using an OID. 



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "TNM",
  "url" : "http://terminology.hl7.org/NamingSystem/TNM",
  "version" : "1.0.0",
  "name" : "TNM",
  "title" : "TNM Staging System",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2022-01-14T00:00:00-00:00",
  "publisher" : "American Joint Committee on Cancer",
  "contact" : [
    {
      "name" : "American Joint Committee on Cancer; 633 N. Saint Clair St., Chicago, IL 60611-3211",
      "telecom" : [
        {
          "system" : "email",
          "value" : "ajcc@facs.org"
        },
        {
          "system" : "phone",
          "value" : "(312) 202-5205"
        },
        {
          "system" : "url",
          "value" : "https://cancerstaging.org/"
        }
      ]
    }
  ],
  "responsible" : "American Joint Committee on Cancer",
  "description" : "The TNM Staging System was developed and is maintained by the AJCC and the Union for International Cancer Control (UICC). It is the most commonly used staging system by medical professionals around the world. The TNM classification system was developed as a tool for doctors to stage different types of cancer based on certain, standardized criteria. The TNM Staging System is based on the extent of the tumor (T), the extent of spread to the lymph nodes (N), and the presence of metastasis (M).\r\n\r\nHTA Note: Most content of TNM (V6) is in the SNOMED international release but not content from the most recent (V9).  In Europe many countries use TNM codes, taken from the book and referenced using an OID.",
  "copyright" : "The AJCC may grant permission for use of copyrighted material from the AJCC Cancer Staging Manual to outside individuals and organizations at its own discretion. No changes to, additions to, or deletions from the copied or reused material should be made without prior written approval of the AJCC. Permission applies only to the material and use specified in correspondence. New requests should be made for subsequent use or for other uses of material.\r\n\r\nTo license AJCC content for commercial use in electronic health record (EHR) systems or other software and applications, please email ajcc@facs.org for more information on licensing our API.\r\n\r\nTo request permission to photocopy, duplicate, republish, or otherwise reuse AJCC material in journals, presentations or course material, follow the instructions below.\r\n\r\nFor Sixth, Seventh, Eighth Editions please contact bookpermissions@springernature.com.\r\n\r\nFor Fifth Edition please contact the publisher at healthpermissions@wolterskluwer.com.\r\n\r\nPlease note that some items in the manual are reproduced with permission from other rights holders. If you wish to reproduce any of those items, you must request permission from the original rights holders. This is often possible through www.copyright.com.",
  "uniqueId" : [
    {
      "type" : "uri",
      "value" : "https://cancerstaging.org",
      "preferred" : true,
      "comment" : "This is the URL as specified by the terminology owner, and is considered authoritative.",
      "period" : {
        "start" : "2021-11-03"
      }
    }
  ]
}

```
