# Source of Payment Typology - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Source of Payment Typology**

## NamingSystem: Source of Payment Typology 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/SOPT | *Version*:2.0.0 | |
| Active as of 2025-07-14 | *Responsible:*[U.S. Centers for Disease Control and Prevention (CDC)](https://www.cdc.gov/nchs) | *Computable Name*:SOPT |

 
The Source of Payment Typology (SOPT) is maintained by the Centers for Disease Control and Prevention (CDC), National Center for Health Statistics (NCHS). 
The code system is used to allow consistent reporting of payer data to public health agencies for health care services and research, and to exchange health insurance payer and program information. 
See[https://phinvads.cdc.gov/vads/ViewCodeSystem.action?id=2.16.840.1.113883.3.221.5](https://phinvads.cdc.gov/vads/ViewCodeSystem.action?id=2.16.840.1.113883.3.221.5) 



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "SOPT",
  "url" : "http://terminology.hl7.org/NamingSystem/SOPT",
  "version" : "2.0.0",
  "name" : "SOPT",
  "title" : "Source of Payment Typology",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2025-07-14T00:00:00-00:00",
  "publisher" : "U.S. Centers for Disease Control and Prevention (CDC)",
  "contact" : [
    {
      "name" : "Centers for Disease Control and Prevention, National Center for Health Statistics ; 3311 Toledo Road Hyattsville, MD 20782",
      "telecom" : [
        {
          "system" : "phone",
          "value" : "301-458-4000"
        },
        {
          "system" : "email",
          "value" : "sopt@cdc.gov"
        },
        {
          "system" : "url",
          "value" : "https://www.cdc.gov/nchs"
        }
      ]
    }
  ],
  "description" : "The Source of Payment Typology (SOPT) is maintained by the Centers for Disease Control and Prevention (CDC), National Center for Health Statistics (NCHS).\r\n\r\nThe code system is used to allow consistent reporting of payer data to public health agencies for health care services and research, and to exchange health insurance payer and program information.\r\n\r\nSee [https://phinvads.cdc.gov/vads/ViewCodeSystem.action?id=2.16.840.1.113883.3.221.5](https://phinvads.cdc.gov/vads/ViewCodeSystem.action?id=2.16.840.1.113883.3.221.5)",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.3.221.5",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "https://nahdo.org/sopt",
      "preferred" : true,
      "period" : {
        "start" : "2020-05-20T00:00:00-00:00"
      }
    },
    {
      "type" : "uri",
      "value" : "urn:oid:2.16.840.1.113883.3.221.5",
      "preferred" : false,
      "period" : {
        "start" : "2024-01-01T00:00:00-00:00"
      }
    }
  ]
}

```
