# Sequence Ontology - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Sequence Ontology**

## NamingSystem: Sequence Ontology 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/SO | *Version*:1.0.0 | |
| Active as of 2023-12-11 | *Responsible:*[Sequence Ontology](http://www.sequenceontology.org) | *Computable Name*:SO |
| **Copyright/Legal**: The Sequence Ontology: A tool for the unification of genome annotations. Eilbeck K., Lewis S.E., Mungall C.J., Yandell M., Stein L., Durbin R., Ashburner M.[Genome Biology (2005) 6:R44](http://genomebiology.com/2005/6/5/R44)Please also include the version of SO used.Sequence Ontology data and data products are licensed under the[Creative Commons Attribution 4.0 Unported License](https://creativecommons.org/licenses/by/4.0/legalcode). | | |

 
"The Sequence Ontology is a set of terms and relationships used to describe the features and attributes of biological sequence. SO includes different kinds of features which can be located on the sequence. Biological features are those which are defined by their disposition to be involved in a biological process." 
"The Sequence Ontologies are provided as a resource to the biological community. They have the following obvious uses: 
* To provide for a structured controlled vocabulary for the description of primary annotations of nucleic acid sequence, e.g. the annotations shared by a DAS server ([BioDAS](http://www.biodas.org/documents/das2/das2_protocol.html), [Biosapiens DAS](http://www.biosapiens.info/page.php?page=das_portal)), or annotations encoded by [GFF3](http://www.sequenceontology.org/gff3.shtml)."
* To provide for a structured representation of these annotations within databases. Were genes within model organism databases to be annotated with these terms then it would be possible to query all these databases for, for example, all genes whose transcripts are edited, or trans-spliced, or are bound by a particular protein. One such genomic database is [Chado](http://www.gmod.org/wiki/Chado).
* To provide a structured controlled vocabulary for the description of mutations at both the sequence and more gross level in the context of genomic databases."
 
"The Sequence Ontology is part of[OBO](http://www.obofoundry.org/). It has close links to other ontology projects such as the[RNAO consortium](http://roc.bgsu.edu/), and the[Biosapiens polypeptide features](http://www.ebi.ac.uk/ontology-lookup/browse.do?ontName=BS)." 
The content can be browsed[here](http://www.sequenceontology.org/browser/obob.cgi) 
The content can be downloaded[here](https://github.com/The-Sequence-Ontology/SO-Ontologies) 
For information on contributing, please see[here](https://github.com/The-Sequence-Ontology/SO-Ontologies#contributing) 
To request a term or register feedback, see[here](https://github.com/The-Sequence-Ontology/SO-Ontologies/issues) 



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "SO",
  "url" : "http://terminology.hl7.org/NamingSystem/SO",
  "version" : "1.0.0",
  "name" : "SO",
  "title" : "Sequence Ontology",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2023-12-11T00:00:00-00:00",
  "publisher" : "Sequence Ontology",
  "contact" : [
    {
      "name" : "Sequence Ontology; Karen Eilbeck (PI), Barry Moore (Software Developer), Shawn Rynearson (Software Developer)",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.sequenceontology.org"
        },
        {
          "system" : "email",
          "value" : "keilbeck@genetics.utah.edu"
        },
        {
          "system" : "email",
          "value" : "barry.moore@genetics.utah.edu"
        },
        {
          "system" : "email",
          "value" : "shawn.rynearson@gmail.com"
        }
      ]
    }
  ],
  "description" : "\"The Sequence Ontology is a set of terms and relationships used to describe the features and attributes of biological sequence. SO includes different kinds of features which can be located on the sequence. Biological features are those which are defined by their disposition to be involved in a biological process.\"\r\n\r\n\"The Sequence Ontologies are provided as a resource to the biological community. They have the following obvious uses:\r\n\r\n* To provide for a structured controlled vocabulary for the description of primary annotations of nucleic acid sequence, e.g. the annotations shared by a DAS server ([BioDAS](http://www.biodas.org/documents/das2/das2_protocol.html), [Biosapiens DAS](http://www.biosapiens.info/page.php?page=das_portal)), or annotations encoded by [GFF3](http://www.sequenceontology.org/gff3.shtml).\"\r\n\r\n* To provide for a structured representation of these annotations within databases. Were genes within model organism databases to be annotated with these terms then it would be possible to query all these databases for, for example, all genes whose transcripts are edited, or trans-spliced, or are bound by a particular protein. One such genomic database is [Chado](http://www.gmod.org/wiki/Chado).\r\n\r\n* To provide a structured controlled vocabulary for the description of mutations at both the sequence and more gross level in the context of genomic databases.\"\r\n\r\n\"The Sequence Ontology is part of [OBO](http://www.obofoundry.org/). It has close links to other ontology projects such as the [RNAO consortium](http://roc.bgsu.edu/), and the [Biosapiens polypeptide features](http://www.ebi.ac.uk/ontology-lookup/browse.do?ontName=BS).\"\r\n\r\nThe content can be browsed [here](http://www.sequenceontology.org/browser/obob.cgi)\r\n\r\nThe content can be downloaded [here](https://github.com/The-Sequence-Ontology/SO-Ontologies)\r\n\r\nFor information on contributing, please see [here](https://github.com/The-Sequence-Ontology/SO-Ontologies#contributing)\r\n\r\nTo request a term or register feedback, see [here](https://github.com/The-Sequence-Ontology/SO-Ontologies/issues)",
  "copyright" : "The Sequence Ontology: A tool for the unification of genome annotations. Eilbeck K., Lewis S.E., Mungall C.J., Yandell M., Stein L., Durbin R., Ashburner M. [Genome Biology (2005) 6:R44](http://genomebiology.com/2005/6/5/R44)\r\n\r\nPlease also include the version of SO used.\r\n\r\nSequence Ontology data and data products are licensed under the [Creative Commons Attribution 4.0 Unported License](https://creativecommons.org/licenses/by/4.0/legalcode).",
  "uniqueId" : [
    {
      "type" : "uri",
      "value" : "http://www.sequenceontology.org",
      "preferred" : true,
      "comment" : "This is the URL as specified by the terminology owner, and is considered authoritative.",
      "period" : {
        "start" : "2021-06-07"
      }
    }
  ]
}

```
