# PMIX Patient Alert Category Code - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PMIX Patient Alert Category Code**

## NamingSystem: PMIX Patient Alert Category Code 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/PMIXPatientAlertCatCode | *Version*:1.0.0 | |
| Active as of 2024-06-03 | *Responsible:*[Prescription Monitoring Information eXchange (PMIX) Standards Organization](https://www.pdmpassist.org/PMIX) | *Computable Name*:PMIXPatientAlertCatCode |
| **Copyright/Legal**: The owner of this code system has confirmed that it is open source and freely available. | | |

 
This code system is part of the PMIX National Architecture. The Prescription Monitoring Information eXchange (PMIX) Standards Organization is the sole body responsible for developing, updating and maintaining all aspects of the PMIX National Architecture and any related standards, documentation and/or guidance documents. The PMIX Standards Organization is made up of State Prescription Drug Monitoring Programs, Prescription Drug Monitoring Program Vendors, Third-Party Intermediaries and Federal Agencies. The appropriate contacts for PMIX are the Chair and Vice Chair of the PMIX Executive Committee. 
Chair:[Chad Garner](mailto:chad.garner@pharmacy.ohio.gov) 
Vice Chair:[Chelsea Townsend](mailto:townseca@dhec.sc.gov) 
Patient Alert Category Code: In the event that the PDMP (Prescription Drug Monitoring Program) utilizes an “alert” functionality – a functionality that alerts an end user to some known or detected activity or condition regarding the requested patient – the alert category code indicates what type of alert was detected and is being sent by the PDMP. 



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "PMIXPatientAlertCatCode",
  "url" : "http://terminology.hl7.org/NamingSystem/PMIXPatientAlertCatCode",
  "version" : "1.0.0",
  "name" : "PMIXPatientAlertCatCode",
  "title" : "PMIX Patient Alert Category Code",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2024-06-03T00:00:00-00:00",
  "publisher" : "Prescription Monitoring Information eXchange (PMIX) Standards Organization",
  "contact" : [
    {
      "name" : "Prescription Monitoring Information eXchange (PMIX) Standards Organization",
      "telecom" : [
        {
          "system" : "email",
          "value" : "pdmpttac@iir.com"
        },
        {
          "system" : "url",
          "value" : "https://www.pdmpassist.org/PMIX"
        },
        {
          "system" : "phone",
          "value" : "1-850-481-PDMP"
        }
      ]
    }
  ],
  "description" : "This code system is part of the PMIX National Architecture. The Prescription Monitoring Information eXchange (PMIX) Standards Organization is the sole body responsible for developing, updating and maintaining all aspects of the PMIX National Architecture and any related standards, documentation and/or guidance documents. The PMIX Standards Organization is made up of State Prescription Drug Monitoring Programs, Prescription Drug Monitoring Program Vendors, Third-Party Intermediaries and Federal Agencies. The appropriate contacts for PMIX are the Chair and Vice Chair of the PMIX Executive Committee.\r\n\r\nChair: [Chad Garner](mailto:chad.garner@pharmacy.ohio.gov)\r\n\r\nVice Chair: [Chelsea Townsend](mailto:townseca@dhec.sc.gov)\r\n\r\nPatient Alert Category Code: In the event that the PDMP (Prescription Drug Monitoring Program) utilizes an “alert” functionality – a functionality that alerts an end user to some known or detected activity or condition regarding the requested patient – the alert category code indicates what type of alert was detected and is being sent by the PDMP.",
  "copyright" : "The owner of this code system has confirmed that it is open source and freely available.",
  "uniqueId" : [
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/PMIXPatientAlertCatCode",
      "preferred" : true,
      "period" : {
        "start" : "2024-06-03"
      }
    }
  ]
}

```
