# ILRSpeakingSkillScale - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ILRSpeakingSkillScale**

## NamingSystem: ILRSpeakingSkillScale 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/ILRSpeakingSkillScale | *Version*: | |
| Active as of 2024-07-01 | *Responsible:*[Interagency Language Roundtable; Defense Language Institute; 2530 Crystal Drive, Suite 1600, Arlington, VA 22202](https://www.govtilr.org/) | *Computable Name*:ILRSpeakingSkillScale |
| **Copyright/Legal**: The ILR Speaking Skill codes are in the public domain and are free to use without restriction. | | |

 
The following Interagency Language Roundtable (ILR) Skill Level Descriptions (SLDs) describe proficiency as the functional ability to produce spoken language that reflects current usage. The SLDs characterize proficiency ranging from no communicative ability to mastery. They constitute an ordinal scale that includes six ranked base levels from 0 to 5. They illustrate, but do not exhaustively characterize, the proficiency a person may demonstrate at a given level on the scale. 
Control of a base level (Levels 1, 2, 3, 4, and 5) typically implies control of the previous levels' aspects. A higher level of performance in one aspect does not justify a higher general proficiency rating. Level 5 includes the features of all levels. Still, as with all levels, Level 5 is a range and performance will vary. 
There are plus levels for levels 0 through 4. Plus levels describe proficiency that substantially exceeds one base level and does not fully meet the criteria of the next base level. To merit a plus level, the demonstrated proficiency must match the plus level description and not be merely a strong performance at the base level. 
The SLDs describe four aspects of language proficiency: functional ability (color coded green), precision of forms and meanings (red), content meaningfulness (black), and contextual appropriateness (blue). Functional ability refers to the communicative acts or tasks that an individual can accomplish. There are no functional abilities specific to the plus levels. Precision of forms and meanings refers to accuracy, range, and complexity. Content meaningfulness refers to the relevance and substantive coverage of topics. Contextual appropriateness refers to register, acceptability, and appropriateness of language for the intended audience. 
The SLDs are presented in an official prose version as well as a supplementary crosswalk matrix. Each level description begins with a bolded main statement that summarizes the features of that level. Color coded supporting statements follow the main statement and describe the four aspects in detail. The crosswalk matrix shows the structure of the SLDs explicitly across the four skills. 
For more information, including the source content, please see[https://www.govtilr.org/Skills/Speaking.htm](https://www.govtilr.org/Skills/Speaking.htm). 



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "ILRSpeakingSkillScale",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-NamingSystem.title",
      "valueString" : "Interagency Language Roundtable Speaking Skill Scale"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-NamingSystem.url",
      "valueUri" : "http://terminology.hl7.org/NamingSystem/ILRSpeakingSkillScale"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-NamingSystem.version",
      "valueString" : "20240701"
    }
  ],
  "url" : "http://terminology.hl7.org/NamingSystem/ILRSpeakingSkillScale",
  "name" : "ILRSpeakingSkillScale",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2024-07-01T00:00:00-00:00",
  "publisher" : "Interagency Language Roundtable; Defense Language Institute; 2530 Crystal Drive, Suite 1600, Arlington, VA 22202",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.govtilr.org/"
        },
        {
          "system" : "email",
          "value" : "govtilr@gmail.com"
        },
        {
          "system" : "phone",
          "value" : "703-692-5397"
        }
      ]
    }
  ],
  "description" : "The following Interagency Language Roundtable (ILR) Skill Level Descriptions (SLDs) describe proficiency as the functional ability to produce spoken language that reflects current usage. The SLDs characterize proficiency ranging from no communicative ability to mastery. They constitute an ordinal scale that includes six ranked base levels from 0 to 5. They illustrate, but do not exhaustively characterize, the proficiency a person may demonstrate at a given level on the scale.\r\n\r\nControl of a base level (Levels 1, 2, 3, 4, and 5) typically implies control of the previous levels' aspects. A higher level of performance in one aspect does not justify a higher general proficiency rating. Level 5 includes the features of all levels. Still, as with all levels, Level 5 is a range and performance will vary.\r\n\r\nThere are plus levels for levels 0 through 4. Plus levels describe proficiency that substantially exceeds one base level and does not fully meet the criteria of the next base level. To merit a plus level, the demonstrated proficiency must match the plus level description and not be merely a strong performance at the base level.\r\n\r\nThe SLDs describe four aspects of language proficiency: functional ability (color coded green), precision of forms and meanings (red), content meaningfulness (black), and contextual appropriateness (blue). Functional ability refers to the communicative acts or tasks that an individual can accomplish. There are no functional abilities specific to the plus levels. Precision of forms and meanings refers to accuracy, range, and complexity. Content meaningfulness refers to the relevance and substantive coverage of topics. Contextual appropriateness refers to register, acceptability, and appropriateness of language for the intended audience.\r\n\r\nThe SLDs are presented in an official prose version as well as a supplementary crosswalk matrix. Each level description begins with a bolded main statement that summarizes the features of that level. Color coded supporting statements follow the main statement and describe the four aspects in detail. The crosswalk matrix shows the structure of the SLDs explicitly across the four skills.\r\n\r\nFor more information, including the source content, please see [https://www.govtilr.org/Skills/Speaking.htm](https://www.govtilr.org/Skills/Speaking.htm).",
  "copyright" : "The ILR Speaking Skill codes are in the public domain and are free to use without restriction.",
  "uniqueId" : [
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/ILRSpeakingSkillScale",
      "preferred" : true
    }
  ]
}

```
