# ICH Context of Use - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ICH Context of Use**

## NamingSystem: ICH Context of Use 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/ICHContextOfUse | *Version*:1.1.0 | |
| Active as of 2025-03-24 | *Responsible:*[International Council for Harmonisation of Technical Requirements for Pharmaceuticals for Human Use (ICH)](https://ich.org/) | *Computable Name*:ICHContextOfUse |
| **Copyright/Legal**: "The information, material and photographic content provided on this website are protected by copyright and may, with the exception of the ICH logo, be used, reproduced, incorporated into other works, adapted, modified, translated or distributed under a public license provided that ICH's copyright in the information and material is acknowledged at all times. In case of any adaption, modification or translation of the information, material or photographic content, reasonable steps must be taken to clearly label, demarcate or otherwise identify that changes were made to or based on the original information or material. Any impression that the adaption, modification or translation of the original information or material is endorsed or sponsored by the ICH must be avoided."For more information, see[https://ich.org/page/legal-mentions](https://ich.org/page/legal-mentions) | | |

 
Codes are found within the vocabulary package at the link above which is available from this page:[https://ich.org/page/ich-electronic-common-technical-document-ectd-v40](https://ich.org/page/ich-electronic-common-technical-document-ectd-v40). Specifically, the codes are in the “ICH Context of Use” tab of the "ICH M8 OID Listing_eCTDv4_v5.xlsx" workbook. The codes are part of the ICH implementation of HL7 V3 Standard: Regulated Studies; Regulated Product Submissions (RPS), Release 2 Normative (described here:[https://www.hl7.org/implement/standards/product_brief.cfm?product_id=38](https://www.hl7.org/implement/standards/product_brief.cfm?product_id=38)) 
When using this uri in FHIR, the version identifier is mandatory and the code system uri cannot be used without it. 
This system uses an integer based versioning system in conjunction with an OID update. For example, if the version of the system is v5, the OID is 2.16.840.1.113883.3.989.2.2.1.1.5. This system has an OID stem of 2.16.840.1.113883.3.989.2.2.1.1. 



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "ICHContextOfUse",
  "url" : "http://terminology.hl7.org/NamingSystem/ICHContextOfUse",
  "version" : "1.1.0",
  "name" : "ICHContextOfUse",
  "title" : "ICH Context of Use",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2025-03-24T00:00:00-00:00",
  "publisher" : "International Council for Harmonisation of Technical Requirements for Pharmaceuticals for Human Use (ICH)",
  "contact" : [
    {
      "name" : "International Council for Harmonisation of Technical Requirements for Pharmaceuticals for Human Use (ICH); Route de Pré-Bois, 20; P.O Box 1894; 1215 Geneva; Switzerland",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://ich.org/"
        },
        {
          "system" : "url",
          "value" : "https://ich.org/page/contact-form"
        },
        {
          "system" : "email",
          "value" : "admin@ich.org"
        }
      ]
    }
  ],
  "responsible" : "International Council for Harmonisation of Technical Requirements for Pharmaceuticals for Human Use (ICH)",
  "description" : "Codes are found within the vocabulary package at the link above which is available from this page: [https://ich.org/page/ich-electronic-common-technical-document-ectd-v40](https://ich.org/page/ich-electronic-common-technical-document-ectd-v40). Specifically, the codes are in the “ICH Context of Use” tab of the \"ICH M8 OID Listing_eCTDv4_v5.xlsx\" workbook. The codes are part of the ICH implementation of HL7 V3 Standard: Regulated Studies; Regulated Product Submissions (RPS), Release 2 Normative (described here: [https://www.hl7.org/implement/standards/product_brief.cfm?product_id=38](https://www.hl7.org/implement/standards/product_brief.cfm?product_id=38))\r\n\r\nWhen using this uri in FHIR, the version identifier is mandatory and the code system uri cannot be used without it.\r\n\r\nThis system uses an integer based versioning system in conjunction with an OID update. For example, if the version of the system is v5, the OID is 2.16.840.1.113883.3.989.2.2.1.1.5. This system has an OID stem of 2.16.840.1.113883.3.989.2.2.1.1.",
  "copyright" : "\"The information, material and photographic content provided on this website are protected by copyright and may, with the exception of the ICH logo, be used, reproduced, incorporated into other works, adapted, modified, translated or distributed under a public license provided that ICH's copyright in the information and material is acknowledged at all times. In case of any adaption, modification or translation of the information, material or photographic content, reasonable steps must be taken to clearly label, demarcate or otherwise identify that changes were made to or based on the original information or material. Any impression that the adaption, modification or translation of the original information or material is endorsed or sponsored by the ICH must be avoided.\"\r\n\r\nFor more information, see [https://ich.org/page/legal-mentions](https://ich.org/page/legal-mentions)",
  "uniqueId" : [
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/ICHContextOfUse",
      "preferred" : true,
      "comment" : "This is the official uri endorsed by TSMG.",
      "period" : {
        "start" : "2025-03-24"
      }
    },
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/temporary-uri/codeSystem/ICH-context-of-use",
      "preferred" : false,
      "comment" : "This was a temporary uri assigned by TSMG. This should be replaced with the official uri.",
      "period" : {
        "start" : "2024-12-12",
        "end" : "2025-03-24"
      }
    }
  ]
}

```
