# International Classification of Functioning, Disability and Health, Dutch Translation - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **International Classification of Functioning, Disability and Health, Dutch Translation**

## NamingSystem: International Classification of Functioning, Disability and Health, Dutch Translation 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/ICFDut | *Version*:1.0.0 | |
| Active as of 2022-10-11 | *Responsible:*[WHO Collaborating Center for the Family of International Classifications (FIC) in the Netherlands](https://www.whofic.nl/over-het-centrum) | *Computable Name*:ICFDut |
| **Copyright/Legal**: Publications of the World Health Organization enjoy copyright protection in accordance with the provisions of Protocol 2 of the Universal Copyright Convention. All rights reserved. | | |

 
"The International Classification of Functioning, Disability and Health, known more commonly as ICF, is a classification of health and health-related domains. As the functioning and disability of an individual occurs in a context, ICF also includes a list of environmental factors. 
ICF is the WHO framework for measuring health and disability at both individual and population levels. 
ICF was officially endorsed by all 191 WHO Member States in the Fifty-fourth World Health Assembly on 22 May 2001(resolution[WHA 54.21](http://apps.who.int/gb/archive/pdf_files/WHA54/ea54r21.pdf)) as the international standard to describe and measure health and disability. 
ICF is based on the same foundation as ICD and ICHI and share the same set of extension codes that enable documentation at a higher level of detail." 
"The Dutch translation of the ICF is published in book form by BSL. The ICF can also be consulted online in the[Classification Browser](https://class.whofic.nl/browser.aspx?scheme=ICF-nl.cla). 
The ICF team of the WHO-FIC Collaborating Center combines expertise in the field of the ICF for the Dutch language area and currently consists of delegations from the Netherlands Paramedical Institute, the University Medical Center Groningen, Maastricht University, the Big Move Institute, Stichting Scientific Research Road Safety, University of Ghent, Vilans, and Rehabilitation Center de Hoogstraat." 
Official updates to the ICF are available as annual lists of changes. 
These updates are approved annually at the October meeting of the WHO Family of International Classifications (WHO-FIC) Network. 
To license ICF, the same rules apply for ICF as for ICD. See[http://icd.who.int/](http://icd.who.int/). 
For more information, see[https://www.whofic.nl/familie-van-internationale-classificaties/referentie-classificaties/icf](https://www.whofic.nl/familie-van-internationale-classificaties/referentie-classificaties/icf). 



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "ICFDut",
  "url" : "http://terminology.hl7.org/NamingSystem/ICFDut",
  "version" : "1.0.0",
  "name" : "ICFDut",
  "title" : "International Classification of Functioning, Disability and Health, Dutch Translation",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2022-10-11T00:00:00-00:00",
  "publisher" : "WHO Collaborating Center for the Family of International Classifications (FIC) in the Netherlands",
  "contact" : [
    {
      "name" : "WHO Collaborating Center for the Family of International Classifications (FIC) in the Netherlands",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.whofic.nl/over-het-centrum"
        }
      ]
    }
  ],
  "responsible" : "WHO Collaborating Center for the Family of International Classifications (FIC) in the Netherlands",
  "description" : "\"The International Classification of Functioning, Disability and Health, known more commonly as ICF, is a classification of health and health-related domains. As the functioning and disability of an individual occurs in a context, ICF also includes a list of environmental factors.\r\n\r\nICF is the WHO framework for measuring health and disability at both individual and population levels.\r\n\r\nICF was officially endorsed by all 191 WHO Member States in the Fifty-fourth World Health Assembly on 22 May 2001(resolution [WHA 54.21](http://apps.who.int/gb/archive/pdf_files/WHA54/ea54r21.pdf) ) as the international standard to describe and measure health and disability.\r\n\r\nICF is based on the same foundation as ICD and ICHI and share the same set of extension codes that enable documentation at a higher level of detail.\"\r\n\r\n\"The Dutch translation of the ICF is published in book form by BSL. The ICF can also be consulted online in the [Classification Browser](https://class.whofic.nl/browser.aspx?scheme=ICF-nl.cla).\r\n\r\nThe ICF team of the WHO-FIC Collaborating Center combines expertise in the field of the ICF for the Dutch language area and currently consists of delegations from the Netherlands Paramedical Institute, the University Medical Center Groningen, Maastricht University, the Big Move Institute, Stichting Scientific Research Road Safety, University of Ghent, Vilans, and Rehabilitation Center de Hoogstraat.\"\r\n\r\nOfficial updates to the ICF are available as annual lists of changes.\r\n\r\nThese updates are approved annually at the October meeting of the WHO Family of International Classifications (WHO-FIC) Network.\r\n\r\nTo license ICF, the same rules apply for ICF as for ICD. See [http://icd.who.int/](http://icd.who.int/).\r\n\r\nFor more information, see [https://www.whofic.nl/familie-van-internationale-classificaties/referentie-classificaties/icf](https://www.whofic.nl/familie-van-internationale-classificaties/referentie-classificaties/icf).",
  "copyright" : "Publications of the World Health Organization enjoy copyright protection in accordance with the provisions of Protocol 2 of the Universal Copyright Convention. All rights reserved.",
  "uniqueId" : [
    {
      "type" : "uri",
      "value" : "http://hl7.org/fhir/sid/icf-nl",
      "preferred" : true,
      "comment" : "This is the URL as specified by the terminology owner, and is considered authoritative.",
      "period" : {
        "start" : "2022-10-13"
      }
    }
  ]
}

```
