# International Classification of Functioning, Disability and Health - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **International Classification of Functioning, Disability and Health**

## NamingSystem: International Classification of Functioning, Disability and Health 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/ICF | *Version*:1.0.0 | |
| Active as of 2022-10-11 | *Responsible:*[World Health Organization](https://www.who.int/standards/classifications/international-classification-of-functioning-disability-and-health) | *Computable Name*:ICF |
| **Copyright/Legal**: Publications of the World Health Organization enjoy copyright protection in accordance with the provisions of Protocol 2 of the Universal Copyright Convention. All rights reserved. | | |

 
"The International Classification of Functioning, Disability and Health, known more commonly as ICF, is a classification of health and health-related domains. As the functioning and disability of an individual occurs in a context, ICF also includes a list of environmental factors. 
ICF is the WHO framework for measuring health and disability at both individual and population levels. 
ICF was officially endorsed by all 191 WHO Member States in the Fifty-fourth World Health Assembly on 22 May 2001(resolution[WHA 54.21](http://apps.who.int/gb/archive/pdf_files/WHA54/ea54r21.pdf)) as the international standard to describe and measure health and disability. 
ICF is based on the same foundation as ICD and ICHI and share the same set of extension codes that enable documentation at a higher level of detail." 
Official updates to the ICF are available as annual lists of changes. 
These updates are approved annually at the October meeting of the WHO Family of International Classifications (WHO-FIC) Network. 
To license ICF, the same rules apply for ICF as for ICD. See[http://icd.who.int/](http://icd.who.int/). 
For more information, see[https://www.who.int/standards/classifications/international-classification-of-functioning-disability-and-health](https://www.who.int/standards/classifications/international-classification-of-functioning-disability-and-health). 



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "ICF",
  "url" : "http://terminology.hl7.org/NamingSystem/ICF",
  "version" : "1.0.0",
  "name" : "ICF",
  "title" : "International Classification of Functioning, Disability and Health",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2022-10-11T00:00:00-00:00",
  "publisher" : "World Health Organization",
  "contact" : [
    {
      "name" : "World Health Organization",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.who.int/standards/classifications/international-classification-of-functioning-disability-and-health"
        }
      ]
    }
  ],
  "responsible" : "World Health Organization",
  "description" : "\"The International Classification of Functioning, Disability and Health, known more commonly as ICF, is a classification of health and health-related domains. As the functioning and disability of an individual occurs in a context, ICF also includes a list of environmental factors.\r\n\r\nICF is the WHO framework for measuring health and disability at both individual and population levels.\r\n\r\nICF was officially endorsed by all 191 WHO Member States in the Fifty-fourth World Health Assembly on 22 May 2001(resolution [WHA 54.21](http://apps.who.int/gb/archive/pdf_files/WHA54/ea54r21.pdf) ) as the international standard to describe and measure health and disability.\r\n\r\nICF is based on the same foundation as ICD and ICHI and share the same set of extension codes that enable documentation at a higher level of detail.\"\r\n\r\nOfficial updates to the ICF are available as annual lists of changes.\r\n\r\nThese updates are approved annually at the October meeting of the WHO Family of International Classifications (WHO-FIC) Network.\r\n\r\nTo license ICF, the same rules apply for ICF as for ICD. See [http://icd.who.int/](http://icd.who.int/).\r\n\r\nFor more information, see [https://www.who.int/standards/classifications/international-classification-of-functioning-disability-and-health](https://www.who.int/standards/classifications/international-classification-of-functioning-disability-and-health).",
  "copyright" : "Publications of the World Health Organization enjoy copyright protection in accordance with the provisions of Protocol 2 of the Universal Copyright Convention. All rights reserved.",
  "uniqueId" : [
    {
      "type" : "uri",
      "value" : "http://hl7.org/fhir/sid/icf",
      "preferred" : true,
      "comment" : "This is the URL as specified by the terminology owner, and is considered authoritative.",
      "period" : {
        "start" : "2022-10-13"
      }
    },
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.6.254",
      "preferred" : true
    }
  ]
}

```
