# American Dental Association Area of Oral Cavity System - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **American Dental Association Area of Oral Cavity System**

## NamingSystem: American Dental Association Area of Oral Cavity System 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/ADAAreaOralCavitySystem | *Version*:1.0.0 | |
| Active as of 2022-04-07 | *Responsible:*American Dental Association | *Computable Name*:ADAAreaOralCavitySystem |
| **Copyright/Legal**: No official copyright statement is available. For general information see paper form located here : https://www.ada.org/-/media/project/ada-organization/ada/ada-org/files/publications/cdt/v2019adadentalclaimcompletioninstructions_v3_2022feb.pdf | | |

 
The Area of Oral Cavity System is accepted and approved by the ADA and is the most commonly used system used by dental professionals in America. 
Area of the oral cavity is designated by a two-digit code. 
The Area of Oral Cavity System can be found in the ADA Comprehensive ADA Dental Claim Form Completion Instructions (see https://www.ada.org/-/media/project/ada-organization/ada/ada-org/files/publications/cdt/v2019adadentalclaimcompletioninstructions_v3_2022feb.pdf). For more information see here: https://www.ada.org/publications/cdt/ada-dental-claim-form. 
A Statement of Understanding (SOU) between ADA and HL7 exists here: http://www.hl7.org/documentcenter/public/mou/ADA%20HL7%20SOU%202021_signed.pdf 



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "ADAAreaOralCavitySystem",
  "url" : "http://terminology.hl7.org/NamingSystem/ADAAreaOralCavitySystem",
  "version" : "1.0.0",
  "name" : "ADAAreaOralCavitySystem",
  "title" : "American Dental Association Area of Oral Cavity System",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2022-04-07T00:00:00-00:00",
  "publisher" : "American Dental Association",
  "contact" : [
    {
      "name" : "American Dental Association; 211 East Chicago Avenue Chicago, IL 60610-2678"
    }
  ],
  "description" : "The Area of Oral Cavity System is accepted and approved by the ADA and is the most commonly used system used by dental professionals in America.\r\n\r\nArea of the oral cavity is designated by a two-digit code.\r\n\r\nThe Area of Oral Cavity System can be found in the ADA Comprehensive ADA Dental Claim Form Completion Instructions (see https://www.ada.org/-/media/project/ada-organization/ada/ada-org/files/publications/cdt/v2019adadentalclaimcompletioninstructions_v3_2022feb.pdf). For more information see here: https://www.ada.org/publications/cdt/ada-dental-claim-form. \r\n\r\nA Statement of Understanding (SOU) between ADA and HL7 exists here: http://www.hl7.org/documentcenter/public/mou/ADA%20HL7%20SOU%202021_signed.pdf",
  "copyright" : "No official copyright statement is available. For general information see paper form located here : https://www.ada.org/-/media/project/ada-organization/ada/ada-org/files/publications/cdt/v2019adadentalclaimcompletioninstructions_v3_2022feb.pdf",
  "uniqueId" : [
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/ADAAreaOralCavitySystem",
      "preferred" : true,
      "comment" : "This is the URL endorsed by the HTA and is considered authoritative.",
      "period" : {
        "start" : "2022-04-07"
      }
    }
  ]
}

```
