# EvidenceVariableRole - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **EvidenceVariableRole**

## CodeSystem: EvidenceVariableRole 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/variable-role | *Version*:2.0.1 | | |
| Active as of 2025-10-25 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 0 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:EvidenceVariableRole |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1457 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | | |

 
**Deprecation Information:**This CodeSystem/ValueSet was used in FHIR R5 for a CodeableConcept binding that was changed to a code binding in FHIR R6. The replacement CodeSystem/ValueSet is http://hl7.org/fhir/variable-role and http://hl7.org/fhir/ValueSet/variable-role. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [EvidenceVariableRole](ValueSet-variable-role.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "variable-role",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00"
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cds"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 0
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/variable-role",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1457"
    }
  ],
  "version" : "2.0.1",
  "name" : "EvidenceVariableRole",
  "title" : "EvidenceVariableRole",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-10-25T00:00:00+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "**Deprecation Information:** This CodeSystem/ValueSet was used in FHIR R5 for a CodeableConcept binding that was changed to a code binding in FHIR R6. The replacement CodeSystem/ValueSet is http://hl7.org/fhir/variable-role and http://hl7.org/fhir/ValueSet/variable-role.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/variable-role",
  "content" : "complete",
  "concept" : [
    {
      "code" : "population",
      "display" : "population",
      "definition" : "variable represents a population."
    },
    {
      "code" : "subpopulation",
      "display" : "subpopulation",
      "definition" : "variable represents a subpopulation."
    },
    {
      "code" : "exposure",
      "display" : "exposure",
      "definition" : "variable represents an exposure."
    },
    {
      "code" : "referenceExposure",
      "display" : "reference exposure",
      "definition" : "variable represents a reference exposure."
    },
    {
      "code" : "measuredVariable",
      "display" : "measured variable",
      "definition" : "variable represents a measured variable."
    },
    {
      "code" : "confounder",
      "display" : "confounder",
      "definition" : "variable represents a confounder."
    },
    {
      "code" : "measuredVariableA",
      "display" : "measured variable A",
      "definition" : "variable represents a first of two measured variables to be used in a measured variable that is a mathematical operation of two measured variables."
    },
    {
      "code" : "measuredVariableB",
      "display" : "measured variable B",
      "definition" : "variable represents a second of two measured variables to be used in a measured variable that is a mathematical operation of two measured variables."
    },
    {
      "code" : "measuredVariableAB",
      "display" : "measured variable A to B",
      "definition" : "variable represents a result of a mathematical operation of two measured variables."
    }
  ]
}

```
