# HL7PublishingDomain - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **HL7PublishingDomain**

## CodeSystem: HL7PublishingDomain 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-hl7PublishingDomain | *Version*:3.0.0 | |
| Active as of 2019-03-20 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:Hl7PublishingDomain |
| *Other Identifiers:*OID:2.16.840.1.113883.5.1136 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
**Description:**Codes for HL7 publishing domains (specific content area) 

 This Code system is referenced in the content logical definition of the following value sets: 

* This CodeSystem is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-hl7PublishingDomain",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-hl7PublishingDomain",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.1136"
    }
  ],
  "version" : "3.0.0",
  "name" : "Hl7PublishingDomain",
  "title" : "HL7PublishingDomain",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "**Description:** Codes for HL7 publishing domains (specific content area)",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "extension" : [
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-relationshipKind",
          "valueCode" : "Other"
        }
      ],
      "code" : "OwningSubSection",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#OwningSubSection",
      "description" : "Identifies the sub-section (target concept) of which this domain (source concept) is a part. ConceptRelationshipProperites: [isNavigable: false; functionalism: functional; reflexivity: irreflexive; symmetry: antisymetric; connected: false; transitivity: antitransitive; allowedForTargets: all codes from the hl7PublishingSubSection code system; requiredForSources: all codes from hl7PublishingDomain code system;]",
      "type" : "Coding"
    },
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state. Normally is not populated unless the state is retired.",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "AB",
      "display" : "accounting & billing",
      "definition" : "**Description:** Represents the HL7 content \"domain\" that supports accounting and billing functions - and \"provides support for the creation and management of patient billing accounts and the post of financial transactions against patient billing accounts for the purpose of aggregating financial transactions that will be submitted as claims or invoices for reimbursemen\"\r\n\r\n*UsageNote:* V3 Specifications are published in a set of \"domains\", which contain interactions and related specifications for a single area of health care within which can be supported by a single, coherent set of interoperability specifications.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "OwningSubSection",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-hl7PublishingSubSection",
            "code" : "FI"
          }
        },
        {
          "code" : "internalId",
          "valueCode" : "23172"
        }
      ]
    },
    {
      "code" : "AI",
      "display" : "trigger event control act infrastructure",
      "definition" : "**Description:** Represents the HL7 content \"domain\" that supports trigger event control act infrastructure - and \"covers the alternate structures of the message Trigger Event Control Acts in the HL7 Composite Message.\"\r\n\r\n*UsageNote:* V3 Specifications are published in a set of \"domains\", which contain interactions and related specifications for a single area of health care within which can be supported by a single, coherent set of interoperability specifications.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "OwningSubSection",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-hl7PublishingSubSection",
            "code" : "MC"
          }
        },
        {
          "code" : "internalId",
          "valueCode" : "23173"
        }
      ]
    },
    {
      "code" : "AL",
      "display" : "artificial listing for test purposes - faux Domain for testing",
      "definition" : "**Description:** Represents the HL7 content \"domain\" that was defined as an \"artificial listing\" domain to support publication testing.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "OwningSubSection",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-hl7PublishingSubSection",
            "code" : "RE"
          }
        },
        {
          "code" : "internalId",
          "valueCode" : "23174"
        }
      ]
    },
    {
      "code" : "BB",
      "display" : "blood tissue and organ",
      "definition" : "**Description:** Represents the HL7 content \"domain\" that supports blood tissue and organ domain - and \"comprises the models, messages, and other artIfacts that are needed to support messaging related to the process of blood, tissue, and organ banking operations such as donations, eligibility, storage, dispense, administration/transfusion, explantation, and implantation. \"\r\n\r\n*UsageNote:* V3 Specifications are published in a set of \"domains\", which contain interactions and related specifications for a single area of health care within which can be supported by a single, coherent set of interoperability specifications.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "OwningSubSection",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-hl7PublishingSubSection",
            "code" : "PO"
          }
        },
        {
          "code" : "internalId",
          "valueCode" : "23175"
        }
      ]
    },
    {
      "code" : "CD",
      "display" : "clinical document architecture",
      "definition" : "**Description:** Represents the HL7 content \"domain\" that supports the clinical document architecture.\r\n\r\n*UsageNote:* V3 Specifications are published in a set of \"domains\", which contain interactions and related specifications for a single area of health care within which can be supported by a single, coherent set of interoperability specifications.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "OwningSubSection",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-hl7PublishingSubSection",
            "code" : "PO"
          }
        },
        {
          "code" : "internalId",
          "valueCode" : "23176"
        }
      ]
    },
    {
      "code" : "CG",
      "display" : "clinical genomics",
      "definition" : "**Description:** Represents the HL7 content \"domain\" that supports clinical genomics - and includes \" standards to enable the exchange of interrelated clinical and personalized genomic data between interested parties.\"\r\n\r\n*UsageNote:* V3 Specifications are published in a set of \"domains\", which contain interactions and related specifications for a single area of health care within which can be supported by a single, coherent set of interoperability specifications.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "OwningSubSection",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-hl7PublishingSubSection",
            "code" : "PO"
          }
        },
        {
          "code" : "internalId",
          "valueCode" : "23178"
        }
      ]
    },
    {
      "code" : "CI",
      "display" : "transmission infrastructure",
      "definition" : "**Description:** Represents the HL7 content \"domain\" that supports transmission infrastructure - and \" is primarily concerned with the data content of exchanges between healthcare applications, the sequence or interrelationships in the flow of messages and the communication of significant application level exceptions or error conditions.\"\r\n\r\n*UsageNote:* V3 Specifications are published in a set of \"domains\", which contain interactions and related specifications for a single area of health care within which can be supported by a single, coherent set of interoperability specifications.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "OwningSubSection",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-hl7PublishingSubSection",
            "code" : "MC"
          }
        },
        {
          "code" : "internalId",
          "valueCode" : "23177"
        }
      ]
    },
    {
      "code" : "CO",
      "display" : "coverage",
      "definition" : "**Description:** Represents the HL7 content \"domain\" that supports Coverage - and provides support for managing health care coverage in the reimbursement system(s).\r\n\r\n*UsageNote:* V3 Specifications are published in a set of \"domains\", which contain interactions and related specifications for a single area of health care within which can be supported by a single, coherent set of interoperability specifications.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "OwningSubSection",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-hl7PublishingSubSection",
            "code" : "FI"
          }
        },
        {
          "code" : "internalId",
          "valueCode" : "23260"
        }
      ]
    },
    {
      "code" : "CP",
      "display" : "common product model",
      "definition" : "**Description:** Represents the HL7 content \"domain\" that supports the common product model - which \"is used to improve the alignment between the different representations of products used within the body of HL7 Version 3 models.\"\r\n\r\n*UsageNote:* V3 Specifications are published in a set of \"domains\", which contain interactions and related specifications for a single area of health care within which can be supported by a single, coherent set of interoperability specifications.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "OwningSubSection",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-hl7PublishingSubSection",
            "code" : "PO"
          }
        },
        {
          "code" : "internalId",
          "valueCode" : "23179"
        }
      ]
    },
    {
      "code" : "CR",
      "display" : "claims and reimbursement",
      "definition" : "**Description:** Represents the HL7 content \"domain\" that supports Claims and Reimbursement - and \"provides support for Generic, Pharmacy, Preferred Accommodation, Physician, Oral Health Vision Care and Hospital claims for eligibility, authorization, coverage extension, pre-determination, invoice adjudication, payment advice and Statement of Financial Activity (SOFA) Release 3 of this document adds claims messaging support for Physician, Oral Health Vision Care and Hospital claims.\"\r\n\r\n*UsageNote:* V3 Specifications are published in a set of \"domains\", which contain interactions and related specifications for a single area of health care within which can be supported by a single, coherent set of interoperability specifications.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "OwningSubSection",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-hl7PublishingSubSection",
            "code" : "FI"
          }
        },
        {
          "code" : "internalId",
          "valueCode" : "23180"
        }
      ]
    },
    {
      "code" : "CS",
      "display" : "clinical statement",
      "definition" : "**Description:** Represents the HL7 content \"domain\" that supports a common clinical statement pattern - and \"is a 'pattern' designed to be used within multiple HL7 Version 3 domain models. This pattern is intended to facilitate the consistent design of communications that convey clinical information to meet specific use cases.\"\r\n\r\n*UsageNote:* V3 Specifications are published in a set of \"domains\", which contain interactions and related specifications for a single area of health care within which can be supported by a single, coherent set of interoperability specifications.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "OwningSubSection",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-hl7PublishingSubSection",
            "code" : "CO"
          }
        },
        {
          "code" : "internalId",
          "valueCode" : "23181"
        }
      ]
    },
    {
      "code" : "CT",
      "display" : "common types",
      "definition" : "**Description:** Represents the HL7 content \"domain\" that supports common model types - and \"are a work product produced by a particular committee for expressing a common, useful and reusable concept.\"\r\n\r\n*UsageNote:* V3 Specifications are published in a set of \"domains\", which contain interactions and related specifications for a single area of health care within which can be supported by a single, coherent set of interoperability specifications.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "OwningSubSection",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-hl7PublishingSubSection",
            "code" : "CO"
          }
        },
        {
          "code" : "internalId",
          "valueCode" : "23182"
        }
      ]
    },
    {
      "code" : "DD",
      "display" : "dummy domain",
      "definition" : "**Description:** Represents the HL7 content \"domain\" that was created to support testing and initial set-up functions.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "OwningSubSection",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-hl7PublishingSubSection",
            "code" : "UU"
          }
        },
        {
          "code" : "internalId",
          "valueCode" : "23171"
        }
      ]
    },
    {
      "code" : "DI",
      "display" : "diagnostic imaging",
      "definition" : "**Description:** This domain has been retired in favor of \"imaging integration\" (II).",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "OwningSubSection",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-hl7PublishingSubSection",
            "code" : "PO"
          }
        },
        {
          "code" : "internalId",
          "valueCode" : "23183"
        }
      ]
    },
    {
      "code" : "DS",
      "display" : "decision support",
      "definition" : "**Description:** Represents the HL7 content \"domain\" that provides decision support.\r\n\r\n*UsageNote:* V3 Specifications are published in a set of \"domains\", which contain interactions and related specifications for a single area of health care within which can be supported by a single, coherent set of interoperability specifications.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "OwningSubSection",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-hl7PublishingSubSection",
            "code" : "RE"
          }
        },
        {
          "code" : "internalId",
          "valueCode" : "23184"
        }
      ]
    },
    {
      "code" : "EM",
      "display" : "emergency medical services",
      "definition" : "**Description:** Represents the HL7 content \"domain\" that supports Emergency Medical Services.\r\n\r\n*UsageNote:* V3 Specifications are published in a set of \"domains\", which contain interactions and related specifications for a single area of health care within which can be supported by a single, coherent set of interoperability specifications.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "OwningSubSection",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-hl7PublishingSubSection",
            "code" : "PO"
          }
        },
        {
          "code" : "internalId",
          "valueCode" : "23261"
        }
      ]
    },
    {
      "code" : "II",
      "display" : "imaging integration",
      "definition" : "**Description:** Represents the HL7 content \"domain\" that supports imaging integration - and is \"comprises the models, implementation guides, sample documents and images that are needed to illustrate the transformation of DICOM structured reports to CDA Release 2 as well as the creation of CDA diagnostic imaging reports.\"\r\n\r\n*UsageNote:* V3 Specifications are published in a set of \"domains\", which contain interactions and related specifications for a single area of health care within which can be supported by a single, coherent set of interoperability specifications.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "OwningSubSection",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-hl7PublishingSubSection",
            "code" : "PO"
          }
        },
        {
          "code" : "internalId",
          "valueCode" : "23185"
        }
      ]
    },
    {
      "code" : "IZ",
      "display" : "immunization",
      "definition" : "**Description:** Represents the HL7 content \"domain\" that supports immunization - and \"describes communication of information about immunization: the administration of vaccines (and/or antisera) to individuals to prevent infectious disease.\"\r\n\r\n*UsageNote:* V3 Specifications are published in a set of \"domains\", which contain interactions and related specifications for a single area of health care within which can be supported by a single, coherent set of interoperability specifications.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "OwningSubSection",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-hl7PublishingSubSection",
            "code" : "PO"
          }
        },
        {
          "code" : "internalId",
          "valueCode" : "23186"
        }
      ]
    },
    {
      "code" : "LB",
      "display" : "laboratory",
      "definition" : "**Description:** Represents the HL7 content \"domain\" that supports clinical laboratory functions - and is \"comprises the models, messages, and other artifacts that are needed to support messaging related to laboratory tests or observations. \"\r\n\r\n*UsageNote:* V3 Specifications are published in a set of \"domains\", which contain interactions and related specifications for a single area of health care within which can be supported by a single, coherent set of interoperability specifications.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "OwningSubSection",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-hl7PublishingSubSection",
            "code" : "PO"
          }
        },
        {
          "code" : "internalId",
          "valueCode" : "23187"
        }
      ]
    },
    {
      "code" : "ME",
      "display" : "medication",
      "definition" : "**Description:** Represents the HL7 content \"domain\" that supports medication - and \"deals with the description of a medicine for the purposes of messaging information about medicines\" and the applications of these descriptions.\r\n\r\n*UsageNote:* V3 Specifications are published in a set of \"domains\", which contain interactions and related specifications for a single area of health care within which can be supported by a single, coherent set of interoperability specifications.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "OwningSubSection",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-hl7PublishingSubSection",
            "code" : "PO"
          }
        },
        {
          "code" : "internalId",
          "valueCode" : "23188"
        }
      ]
    },
    {
      "code" : "MI",
      "display" : "masterfile infrastructure",
      "definition" : "**Description:** Represents the HL7 content \"domain\" that supports master file infrastructure - and is \"comprises the classes and attributes needed to support Master Files and Registries.\"\r\n\r\n*UsageNote:* V3 Specifications are published in a set of \"domains\", which contain interactions and related specifications for a single area of health care within which can be supported by a single, coherent set of interoperability specifications.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "OwningSubSection",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-hl7PublishingSubSection",
            "code" : "MF"
          }
        },
        {
          "code" : "internalId",
          "valueCode" : "23189"
        }
      ]
    },
    {
      "code" : "MM",
      "display" : "materials management",
      "definition" : "**Description:** Represents the HL7 content \"domain\" that supports Materials Management - and is \"supports the simple scenario of a Materials Management application sending requests, notifications and queries to an auxiliary application. The intent is to establish a standard for the minimum functionality that is useful and comprehensive enough to explore the important concepts relative to inventory management.\"\r\n\r\n*UsageNote:* V3 Specifications are published in a set of \"domains\", which contain interactions and related specifications for a single area of health care within which can be supported by a single, coherent set of interoperability specifications.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "OwningSubSection",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-hl7PublishingSubSection",
            "code" : "PR"
          }
        },
        {
          "code" : "internalId",
          "valueCode" : "23190"
        }
      ]
    },
    {
      "code" : "MR",
      "display" : "medical records",
      "definition" : "**Description:** Represents the HL7 content \"domain\" that supports medical records - and is \"supports clinical document management, and document querying.\"\r\n\r\n*UsageNote:* V3 Specifications are published in a set of \"domains\", which contain interactions and related specifications for a single area of health care within which can be supported by a single, coherent set of interoperability specifications.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "OwningSubSection",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-hl7PublishingSubSection",
            "code" : "RC"
          }
        },
        {
          "code" : "internalId",
          "valueCode" : "23191"
        }
      ]
    },
    {
      "code" : "MT",
      "display" : "shared messages",
      "definition" : "**Description:** Represents the HL7 content \"domain\" that supports shared messages - and \"are a work product produced for expressing common, useful and reusable message types.\"\r\n\r\n*UsageNote:* V3 Specifications are published in a set of \"domains\", which contain interactions and related specifications for a single area of health care within which can be supported by a single, coherent set of interoperability specifications.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "OwningSubSection",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-hl7PublishingSubSection",
            "code" : "CO"
          }
        },
        {
          "code" : "internalId",
          "valueCode" : "23192"
        }
      ]
    },
    {
      "code" : "OB",
      "display" : "observations",
      "definition" : "**Description:** Represents the HL7 content \"domain\" that supports observations - and is \"comprises the models, messages, and other artifacts that are needed to support messaging related to resulting basic healthcare diagnostic services. \"\r\n\r\n*UsageNote:* V3 Specifications are published in a set of \"domains\", which contain interactions and related specifications for a single area of health care within which can be supported by a single, coherent set of interoperability specifications.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "OwningSubSection",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-hl7PublishingSubSection",
            "code" : "PO"
          }
        },
        {
          "code" : "internalId",
          "valueCode" : "23193"
        }
      ]
    },
    {
      "code" : "OO",
      "display" : "orders & observations",
      "definition" : "**Description:** Represents the HL7 content \"domain\" that supports orders and observations - and will provide over-arching support information for the \"Orders\" (OR) and \"Observations\" (OB) domains.\r\n\r\n*UsageNote:* V3 Specifications are published in a set of \"domains\", which contain interactions and related specifications for a single area of health care within which can be supported by a single, coherent set of interoperability specifications.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "OwningSubSection",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-hl7PublishingSubSection",
            "code" : "PO"
          }
        },
        {
          "code" : "internalId",
          "valueCode" : "23194"
        }
      ]
    },
    {
      "code" : "OR",
      "display" : "orders",
      "definition" : "**Description:** Represents the HL7 content \"domain\" that supports orders - and \"comprises the models, messages, and other artifacts that are needed to support messaging related to ordering basic healthcare services.\"\r\n\r\n*UsageNote:* V3 Specifications are published in a set of \"domains\", which contain interactions and related specifications for a single area of health care within which can be supported by a single, coherent set of interoperability specifications.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "OwningSubSection",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-hl7PublishingSubSection",
            "code" : "PO"
          }
        },
        {
          "code" : "internalId",
          "valueCode" : "23195"
        }
      ]
    },
    {
      "code" : "PA",
      "display" : "patient administration",
      "definition" : "**Description:** Represents the HL7 content \"domain\" that supports Patient Administration - and \"defines person and patient demographics and visit information about patients\"\r\n\r\n*UsageNote:* V3 Specifications are published in a set of \"domains\", which contain interactions and related specifications for a single area of health care within which can be supported by a single, coherent set of interoperability specifications.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "OwningSubSection",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-hl7PublishingSubSection",
            "code" : "PR"
          }
        },
        {
          "code" : "internalId",
          "valueCode" : "23196"
        }
      ]
    },
    {
      "code" : "PC",
      "display" : "care provision",
      "definition" : "**Description:** Represents the HL7 content \"domain\" that supports Care Provision - and \"addresses the information that is needed for the ongoing care of individuals, populations, and other targets of care.\"\r\n\r\n*UsageNote:* V3 Specifications are published in a set of \"domains\", which contain interactions and related specifications for a single area of health care within which can be supported by a single, coherent set of interoperability specifications.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "OwningSubSection",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-hl7PublishingSubSection",
            "code" : "RE"
          }
        },
        {
          "code" : "internalId",
          "valueCode" : "23197"
        }
      ]
    },
    {
      "code" : "PH",
      "display" : "public health",
      "definition" : "**Description:** Represents the HL7 content \"domain\" that supports public health - and is \"the source of a number of Common Model Element Types (CMET) designed to meet the needs of public health data exchange.\"\r\n\r\n*UsageNote:* V3 Specifications are published in a set of \"domains\", which contain interactions and related specifications for a single area of health care within which can be supported by a single, coherent set of interoperability specifications.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "OwningSubSection",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-hl7PublishingSubSection",
            "code" : "PO"
          }
        },
        {
          "code" : "internalId",
          "valueCode" : "23198"
        }
      ]
    },
    {
      "code" : "PM",
      "display" : "personnel management",
      "definition" : "**Description:** Represents the HL7 content \"domain\" that supports Personnel Management - and \"spans a variety of clinical-administrative information functions associated with the organizations, individuals, animals and devices involved in the delivery and support of healthcare services.\"\r\n\r\n*UsageNote:* V3 Specifications are published in a set of \"domains\", which contain interactions and related specifications for a single area of health care within which can be supported by a single, coherent set of interoperability specifications.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "OwningSubSection",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-hl7PublishingSubSection",
            "code" : "PR"
          }
        },
        {
          "code" : "internalId",
          "valueCode" : "23199"
        }
      ]
    },
    {
      "code" : "QI",
      "display" : "query infrastructure",
      "definition" : "**Description:** Represents the HL7 content \"domain\" that supports query infrastructure - and \"specifies the formation of information queries and the responses to these queries to meet the needs of healthcare applications using the HL7 version 3 messaging standard.\"\r\n\r\n*UsageNote:* V3 Specifications are published in a set of \"domains\", which contain interactions and related specifications for a single area of health care within which can be supported by a single, coherent set of interoperability specifications.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "OwningSubSection",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-hl7PublishingSubSection",
            "code" : "QU"
          }
        },
        {
          "code" : "internalId",
          "valueCode" : "23200"
        }
      ]
    },
    {
      "code" : "QM",
      "display" : "quality measures",
      "definition" : "**Description:** Represents the HL7 content \"domain\" that supports Quality Measures - and \"is a standard for representing a health quality measure as an electronic document.\"\r\n\r\n*UsageNote:* V3 Specifications are published in a set of \"domains\", which contain interactions and related specifications for a single area of health care within which can be supported by a single, coherent set of interoperability specifications.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "OwningSubSection",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-hl7PublishingSubSection",
            "code" : "PO"
          }
        },
        {
          "code" : "internalId",
          "valueCode" : "23201"
        }
      ]
    },
    {
      "code" : "RG",
      "display" : "registries",
      "definition" : "**Description:** Represents the HL7 content \"domain\" that supports Registries - and \"collects HL7 artifacts for administrative registries.\"\r\n\r\n*UsageNote:* V3 Specifications are published in a set of \"domains\", which contain interactions and related specifications for a single area of health care within which can be supported by a single, coherent set of interoperability specifications.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "OwningSubSection",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-hl7PublishingSubSection",
            "code" : "PR"
          }
        },
        {
          "code" : "internalId",
          "valueCode" : "23202"
        }
      ]
    },
    {
      "code" : "RI",
      "display" : "informative public health",
      "definition" : "**Description:** Represents the HL7 content \"domain\" that supports Informative Public Health.\r\n\r\n*UsageNote:* V3 Specifications are published in a set of \"domains\", which contain interactions and related specifications for a single area of health care within which can be supported by a single, coherent set of interoperability specifications.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "OwningSubSection",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-hl7PublishingSubSection",
            "code" : "PO"
          }
        },
        {
          "code" : "internalId",
          "valueCode" : "23203"
        }
      ]
    },
    {
      "code" : "RP",
      "display" : "regulated products",
      "definition" : "**Description:** Represents the HL7 content \"domain\" that supports Regulated Products - and \"includes standards developed as part of the family of messages targeted for the exchange of information about regulated products and the exchange of the data needed to provide approval for such products.\"\r\n\r\n*UsageNote:* V3 Specifications are published in a set of \"domains\", which contain interactions and related specifications for a single area of health care within which can be supported by a single, coherent set of interoperability specifications.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "OwningSubSection",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-hl7PublishingSubSection",
            "code" : "PO"
          }
        },
        {
          "code" : "internalId",
          "valueCode" : "23204"
        }
      ]
    },
    {
      "code" : "RR",
      "display" : "public health reporting",
      "definition" : "**Description:** Represents the HL7 content \"domain\" that supports Public Health Reporting - and \"includes messages and documents that are specifically designed to support managment, reporting and investigation in the public health context.\"\r\n\r\n*UsageNote:* V3 Specifications are published in a set of \"domains\", which contain interactions and related specifications for a single area of health care within which can be supported by a single, coherent set of interoperability specifications.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "OwningSubSection",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-hl7PublishingSubSection",
            "code" : "PO"
          }
        },
        {
          "code" : "internalId",
          "valueCode" : "23205"
        }
      ]
    },
    {
      "code" : "RT",
      "display" : "regulated studies",
      "definition" : "**Description:** Represents the HL7 content \"domain\" that supports Regulated Studies - and is \"includes standards developed as part of the family of messages targeted for the exchange of information about the conduct of regulated studies, and the exchange of the data collected during those studies.\"\r\n\r\n*UsageNote:* V3 Specifications are published in a set of \"domains\", which contain interactions and related specifications for a single area of health care within which can be supported by a single, coherent set of interoperability specifications.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "OwningSubSection",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-hl7PublishingSubSection",
            "code" : "PO"
          }
        },
        {
          "code" : "internalId",
          "valueCode" : "23206"
        }
      ]
    },
    {
      "code" : "RX",
      "display" : "pharmacy",
      "definition" : "**Description:** Represents the HL7 content \"domain\" that supports pharmacy - and is a \"model used to derive message patterns to describe and communicate processes related to medication.\"\r\n\r\n*UsageNote:* V3 Specifications are published in a set of \"domains\", which contain interactions and related specifications for a single area of health care within which can be supported by a single, coherent set of interoperability specifications.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "OwningSubSection",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-hl7PublishingSubSection",
            "code" : "PO"
          }
        },
        {
          "code" : "internalId",
          "valueCode" : "23207"
        }
      ]
    },
    {
      "code" : "SC",
      "display" : "scheduling",
      "definition" : "**Description:** Represents the HL7 content \"domain\" that supports Scheduling - and \"offers a generic set of messages and behavior to implement any number of Scheduling scenarios.\"\r\n\r\n*UsageNote:* V3 Specifications are published in a set of \"domains\", which contain interactions and related specifications for a single area of health care within which can be supported by a single, coherent set of interoperability specifications.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "OwningSubSection",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-hl7PublishingSubSection",
            "code" : "PR"
          }
        },
        {
          "code" : "internalId",
          "valueCode" : "23208"
        }
      ]
    },
    {
      "code" : "SP",
      "display" : "specimen",
      "definition" : "**Description:** Represents the HL7 content \"domain\" that supports Specimen - and \"comprises the models and artifacts that are needed to support the creation of messaging related to specimen.\"\r\n\r\n*UsageNote:* V3 Specifications are published in a set of \"domains\", which contain interactions and related specifications for a single area of health care within which can be supported by a single, coherent set of interoperability specifications.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "OwningSubSection",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-hl7PublishingSubSection",
            "code" : "PO"
          }
        },
        {
          "code" : "internalId",
          "valueCode" : "23209"
        }
      ]
    },
    {
      "code" : "TD",
      "display" : "therapeutic devices",
      "definition" : "**Description:** Represents the HL7 content \"domain\" that supports Therapeutic Devices - and is \"comprises the models, messages, and other artifacts that are needed to support messaging related to therapy delivery and observations made by a medical device. \"\r\n\r\n*UsageNote:* V3 Specifications are published in a set of \"domains\", which contain interactions and related specifications for a single area of health care within which can be supported by a single, coherent set of interoperability specifications.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "OwningSubSection",
          "valueCoding" : {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-hl7PublishingSubSection",
            "code" : "PO"
          }
        },
        {
          "code" : "internalId",
          "valueCode" : "23210"
        }
      ]
    }
  ]
}

```
