# Systematized Nomenclature of Dentistry (SNODENT) - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Systematized Nomenclature of Dentistry (SNODENT)**

## CodeSystem: Systematized Nomenclature of Dentistry (SNODENT) 

| | |
| :--- | :--- |
| *Official URL*:http://www.ada.org/snodent | *Version*:2.1.0 |
| Active as of 2019-03-20 | *Computable Name*:AdaSnodent |
| *Other Identifiers:*OID:2.16.840.1.113883.3.3150 | |
| **Copyright/Legal**: This HL7 specification contains and references intellectual property owned by third parties ("Third Party IP"). Implementers and testers of this specification SHALL abide by the license requirements for each terminology content artifact utilized within a functioning implementation. Terminology licenses SHALL be obtained from the Third Party IP owner for each code system and/or other specified artifact used. It is the sole responsibility of each organization deploying or testing this specification to ensure their implementations comply with licensing requirements of each Third Party IP. | |

 
Systematized Nomenclature of Dentistry (SNODENT) is owned, maintained and distributed by the American Dental Association (ADA). SNODENT is a vocabulary designed for use in the electronic environment - for electronic health and dental records. The intended purpose is to: 
* Provide standardized terms for describing dental disease
* Capture clinical detail and patient characteristics
* Permit analysis of patient care services and outcomes
* To be interoperable with Electronic Health Records (EHR) and Electronic Dental Records (EDR)
 
SNODENT licensing information can be found at: http://www.ada.org/8466.aspx 
URL for Official Source: http://www.ada.org/snodent.aspx 

 This Code system is referenced in the content logical definition of the following value sets: 

* [SnodentAnteriorInterarchDeviationTypeInternational](ValueSet-v3-SnodentAnteriorInterarchDeviationTypeInternational.md)
* [SnodentCraniofacialAnomalyInternational](ValueSet-v3-SnodentCraniofacialAnomalyInternational.md)
* [SnodentDentalAbnormalityInternational](ValueSet-v3-SnodentDentalAbnormalityInternational.md)
* [SnodentDentalFrenumRegionInternational](ValueSet-v3-SnodentDentalFrenumRegionInternational.md)
* [SnodentDentalPeriodontalProbingPositionInternational](ValueSet-v3-SnodentDentalPeriodontalProbingPositionInternational.md)
* [SnodentDentalToothFurcationSiteInternational](ValueSet-v3-SnodentDentalToothFurcationSiteInternational.md)
* [SnodentDentalToothMobilityMillerClassificationInternational](ValueSet-v3-SnodentDentalToothMobilityMillerClassificationInternational.md)
* [SnodentDentalUniversalNumberingSystemInternational](ValueSet-v3-SnodentDentalUniversalNumberingSystemInternational.md)
* [SnodentDentitionStateInternational](ValueSet-v3-SnodentDentitionStateInternational.md)
* [SnodentJawTypeInternational](ValueSet-v3-SnodentJawTypeInternational.md)
* [SnodentOralCavityAreaInternational](ValueSet-v3-SnodentOralCavityAreaInternational.md)
* [SnodentOrthodonticDiagnosticFeatureInternational](ValueSet-v3-SnodentOrthodonticDiagnosticFeatureInternational.md)
* [SnodentOrthodonticTreatmentPreconditionInternational](ValueSet-v3-SnodentOrthodonticTreatmentPreconditionInternational.md)
* [SnodentPosteriorInterarchDeviationTypeInternational](ValueSet-v3-SnodentPosteriorInterarchDeviationTypeInternational.md)
* [SnodentSalzmannInterarchDeviationMaxillaryToothInternational](ValueSet-v3-SnodentSalzmannInterarchDeviationMaxillaryToothInternational.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-ada-snodent",
  "language" : "en",
  "url" : "http://www.ada.org/snodent",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.3.3150"
    }
  ],
  "version" : "2.1.0",
  "name" : "AdaSnodent",
  "title" : "Systematized Nomenclature of Dentistry (SNODENT)",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-03-20",
  "description" : "Systematized Nomenclature of Dentistry (SNODENT) is owned, maintained and distributed by the American Dental Association (ADA). SNODENT is a vocabulary designed for use in the electronic environment - for electronic health and dental records. The intended purpose is to:\r\n\r\n *  Provide standardized terms for describing dental disease\r\n *  Capture clinical detail and patient characteristics\r\n *  Permit analysis of patient care services and outcomes\r\n *  To be interoperable with Electronic Health Records (EHR) and Electronic Dental Records (EDR)\r\n\r\nSNODENT licensing information can be found at: http://www.ada.org/8466.aspx\r\n\r\nURL for Official Source: http://www.ada.org/snodent.aspx",
  "copyright" : "This HL7 specification contains and references intellectual property owned by third parties (\"Third Party IP\").  Implementers and testers of this specification SHALL abide by the license requirements for each terminology content artifact utilized within a functioning implementation. Terminology licenses SHALL be obtained from the Third Party IP owner for each code system and/or other specified artifact used. It is the sole responsibility of each organization deploying or testing this specification to ensure their implementations comply with licensing requirements of each Third Party IP.",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "fragment",
  "property" : [
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state. Normally is not populated unless the state is retired.",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "100203D",
      "display" : "Tooth Absent",
      "definition" : "Tooth Absent",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "24020"
        }
      ]
    },
    {
      "code" : "103356D",
      "display" : "Lingual Surface",
      "definition" : "The lingual aspect of the tooth.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23849"
        }
      ]
    },
    {
      "code" : "103387D",
      "display" : "Buccal Surface",
      "definition" : "The buccal aspect of the tooth.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23848"
        }
      ]
    },
    {
      "code" : "104161D",
      "display" : "Impacted tooth",
      "definition" : "Impacted tooth",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "24021"
        }
      ]
    },
    {
      "code" : "108042D",
      "display" : "Bone structure of maxilla",
      "definition" : "Bone structure of maxilla",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "24027"
        }
      ]
    },
    {
      "code" : "115902D",
      "display" : "Cleft palate with cleft lip",
      "definition" : "Cleft palate with cleft lip",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "24008"
        }
      ]
    },
    {
      "code" : "116259D",
      "display" : "Supernumerary tooth",
      "definition" : "Supernumerary tooth",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "24023"
        }
      ]
    },
    {
      "code" : "116762D",
      "display" : "Tooth mobility - grade 1",
      "definition" : "Tooth can be moved less than 1mm in the buccolingual or mesiodistal direction",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23845"
        }
      ]
    },
    {
      "code" : "117349D",
      "display" : "Juvenile rheumatoid arthritis",
      "definition" : "Juvenile rheumatoid arthritis",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "24018"
        }
      ]
    },
    {
      "code" : "121288D",
      "display" : "Primary Dentition",
      "definition" : "Primary Dentition",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "24024"
        }
      ]
    },
    {
      "code" : "121344D",
      "display" : "Anterior open bite",
      "definition" : "Anterior open bite",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "24036"
        }
      ]
    },
    {
      "code" : "122924D",
      "display" : "Hemifacial microsomia",
      "definition" : "Hemifacial microsomia",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "24011"
        }
      ]
    },
    {
      "code" : "127066D",
      "display" : "Ankylosis of tooth",
      "definition" : "Ankylosis of tooth",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "24022"
        }
      ]
    },
    {
      "code" : "127434D",
      "display" : "Posterior crossbite",
      "definition" : "Posterior crossbite",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "24039"
        }
      ]
    },
    {
      "code" : "132513D",
      "display" : "Mesial Surface",
      "definition" : "The mesial aspect of the tooth.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23850"
        }
      ]
    },
    {
      "code" : "132578D",
      "display" : "Cleft palate",
      "definition" : "Cleft palate",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "24010"
        }
      ]
    },
    {
      "code" : "133426D",
      "display" : "Gingival Recession",
      "definition" : "Gingival Recession",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "24005"
        }
      ]
    },
    {
      "code" : "133572D",
      "display" : "Cleidocranial dysostosis",
      "definition" : "Cleidocranial dysostosis",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "24013"
        }
      ]
    },
    {
      "code" : "136123D",
      "display" : "Tooth mobility - grade 2",
      "definition" : "Tooth can be moved 1mm or more in the buccolingual or mesiodistal direction. No mobility in the occlusoapical direction (vertical mobility).",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23846"
        }
      ]
    },
    {
      "code" : "137027D",
      "display" : "Anterior crossbite",
      "definition" : "Anterior crossbite",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "24035"
        }
      ]
    },
    {
      "code" : "138900D",
      "display" : "Defective dental restoration",
      "definition" : "Defective dental restoration",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23998"
        }
      ]
    },
    {
      "code" : "139017D",
      "display" : "Permanent Dentition",
      "definition" : "Permanent Dentition",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "24026"
        }
      ]
    },
    {
      "code" : "139277D",
      "display" : "Facial surface of tooth",
      "definition" : "The side of a tooth adjacent to the inside of the cheek or lips.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23859"
        }
      ]
    },
    {
      "code" : "139347D",
      "display" : "Ectopic tooth",
      "definition" : "Ectopic tooth",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "24019"
        }
      ]
    },
    {
      "code" : "140234D",
      "display" : "Poor oral hygiene",
      "definition" : "Poor oral hygiene",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23995"
        }
      ]
    },
    {
      "code" : "141881D",
      "display" : "Posterior open bite",
      "definition" : "Posterior open bite",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "24040"
        }
      ]
    },
    {
      "code" : "143353D",
      "display" : "Temporomandibular joint disorder",
      "definition" : "Temporomandibular joint disorder",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23996"
        }
      ]
    },
    {
      "code" : "144511D",
      "display" : "Bone structure of mandible",
      "definition" : "Bone structure of mandible",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "24028"
        }
      ]
    },
    {
      "code" : "146014D",
      "display" : "Distal Surface",
      "definition" : "The distal aspect of the tooth.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23851"
        }
      ]
    },
    {
      "code" : "146718D",
      "display" : "Treacher Collins syndrome",
      "definition" : "Treacher Collins syndrome",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "24014"
        }
      ]
    },
    {
      "code" : "149641D",
      "display" : "Tooth mobility - grade 3",
      "definition" : "Tooth can be moved 1mm or more in the buccolingual or mesiodistal direction. Mobility in the occlusoapical direction is also present (vertical mobility)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23847"
        }
      ]
    },
    {
      "code" : "149694D",
      "display" : "Cleft lip",
      "definition" : "Cleft lip",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "24007"
        }
      ]
    },
    {
      "code" : "157044D",
      "display" : "Bimaxillary protrusion",
      "definition" : "Bimaxillary protrusion",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "24004"
        }
      ]
    },
    {
      "code" : "160654D",
      "display" : "Permanent lower left first premolar tooth",
      "definition" : "Permanent mandibular left first premolar tooth; Universal designation 21; ISO designation 34",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23813"
        }
      ]
    },
    {
      "code" : "160704D",
      "display" : "Permanent lower right second molar tooth",
      "definition" : "Permanent mandibular right second molar tooth; Universal designation 31; ISO designation 47",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23823"
        }
      ]
    },
    {
      "code" : "160770D",
      "display" : "Permanent lower right first molar tooth",
      "definition" : "Permanent mandibular right first molar tooth; Universal designation 30; ISO designation 46",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23822"
        }
      ]
    },
    {
      "code" : "160817D",
      "display" : "Permanent lower left canine tooth",
      "definition" : "Permanent mandibular left canine tooth; Universal designation 22; ISO designation 33",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23814"
        }
      ]
    },
    {
      "code" : "160840D",
      "display" : "Permanent upper right canine tooth",
      "definition" : "Permanent maxillary right canine tooth; Universal designation 6; ISO designation 13",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23798"
        }
      ]
    },
    {
      "code" : "160903D",
      "display" : "Permanent upper right central incisor tooth",
      "definition" : "Permanent maxillary right central incisor tooth; Universal designation 8; ISO designation 11",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23800"
        }
      ]
    },
    {
      "code" : "160957D",
      "display" : "Permanent upper left canine tooth",
      "definition" : "Permanent maxillary left canine tooth; Universal designation 11; ISO designation 23",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23803"
        }
      ]
    },
    {
      "code" : "161006D",
      "display" : "Permanent upper left central incisor tooth",
      "definition" : "Permanent maxillary left central incisor tooth; Universal designation 9; ISO designation 21",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23801"
        }
      ]
    },
    {
      "code" : "161010D",
      "display" : "Permanent upper right first molar tooth",
      "definition" : "Permanent maxillary right first molar tooth; Universal designation 3; ISO designation 16",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23795"
        }
      ]
    },
    {
      "code" : "161068D",
      "display" : "Permanent lower left central incisor tooth",
      "definition" : "Permanent mandibular left central incisor tooth; Universal designation 24; ISO designation 31",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23816"
        }
      ]
    },
    {
      "code" : "161109D",
      "display" : "Permanent upper left lateral incisor tooth",
      "definition" : "Permanent maxillary left lateral incisor tooth; Universal designation 10; ISO designation 22",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23802"
        }
      ]
    },
    {
      "code" : "161121D",
      "display" : "Permanent lower right third molar tooth",
      "definition" : "Permanent mandibular right third molar tooth; Universal designation 32; ISO designation 48",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23824"
        }
      ]
    },
    {
      "code" : "161132D",
      "display" : "Permanent upper left first molar tooth",
      "definition" : "Permanent maxillary left first molar tooth; Universal designation 14; ISO designation 26",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23806"
        }
      ]
    },
    {
      "code" : "161150D",
      "display" : "Permanent lower left second premolar tooth",
      "definition" : "Permanent mandibular left second premolar tooth; Universal designation 20; ISO designation 35",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23812"
        }
      ]
    },
    {
      "code" : "161178D",
      "display" : "Permanent upper left second premolar tooth",
      "definition" : "Permanent maxillary left second premolar tooth; Universal designation 13; ISO designation 25",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23805"
        }
      ]
    },
    {
      "code" : "161197D",
      "display" : "Permanent lower right lateral incisor tooth",
      "definition" : "Permanent mandibular right lateral incisor tooth; Universal designation 26; ISO designation 42",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23818"
        }
      ]
    },
    {
      "code" : "161227D",
      "display" : "Permanent upper right third molar tooth",
      "definition" : "Permanent maxillary right third molar tooth; Universal designation 1; ISO designation 18",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23793"
        }
      ]
    },
    {
      "code" : "161258D",
      "display" : "Permanent lower left third molar tooth",
      "definition" : "Permanent mandibular left third molar tooth; Universal designation 17; ISO designation 38",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23809"
        }
      ]
    },
    {
      "code" : "161262D",
      "display" : "Permanent upper right second molar tooth",
      "definition" : "Permanent maxillary right second molar tooth; Universal designation 2; ISO designation 17",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23794"
        }
      ]
    },
    {
      "code" : "161291D",
      "display" : "Permanent lower right central incisor tooth",
      "definition" : "Permanent mandibular right central incisor tooth; Universal designation 25; ISO designation 41",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23817"
        }
      ]
    },
    {
      "code" : "161317D",
      "display" : "Permanent upper left second molar tooth",
      "definition" : "Permanent maxillary left second molar tooth; Universal designation 15; ISO designation 27",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23807"
        }
      ]
    },
    {
      "code" : "161329D",
      "display" : "Permanent upper left first premolar tooth",
      "definition" : "Permanent maxillary left first premolar tooth; Universal designation 12; ISO designation 24",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23804"
        }
      ]
    },
    {
      "code" : "161372D",
      "display" : "Permanent lower left second molar tooth",
      "definition" : "Permanent mandibular left second molar tooth; Universal designation 18; ISO designation 37",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23810"
        }
      ]
    },
    {
      "code" : "161412D",
      "display" : "Permanent lower right second premolar tooth",
      "definition" : "Permanent mandibular right second premolar tooth; Universal designation 29; ISO designation 45",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23821"
        }
      ]
    },
    {
      "code" : "161454D",
      "display" : "Permanent upper left third molar tooth",
      "definition" : "Permanent maxillary left third molar tooth; Universal designation 16; ISO designation 28",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23808"
        }
      ]
    },
    {
      "code" : "161477D",
      "display" : "Permanent lower left lateral incisor tooth",
      "definition" : "Permanent mandibular left lateral incisor tooth; Universal designation 23; ISO designation 32",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23815"
        }
      ]
    },
    {
      "code" : "161496D",
      "display" : "Permanent lower right first premolar tooth",
      "definition" : "Permanent mandibular right first premolar tooth; Universal designation 28; ISO designation 44",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23820"
        }
      ]
    },
    {
      "code" : "161514D",
      "display" : "Permanent lower right canine tooth",
      "definition" : "Permanent mandibular right canine tooth; Universal designation 27; ISO designation 43",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23819"
        }
      ]
    },
    {
      "code" : "161533D",
      "display" : "Permanent lower left first molar tooth",
      "definition" : "Permanent mandibular left first molar tooth; Universal designation 19; ISO designation 36",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23811"
        }
      ]
    },
    {
      "code" : "161546D",
      "display" : "Permanent upper right second premolar tooth",
      "definition" : "Permanent maxillary right second premolar tooth; Universal designation 4; ISO designation 15",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23796"
        }
      ]
    },
    {
      "code" : "161607D",
      "display" : "Permanent upper right first premolar tooth",
      "definition" : "Permanent maxillary right first premolar tooth; Universal designation 5; ISO designation 14",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23797"
        }
      ]
    },
    {
      "code" : "161892D",
      "display" : "Primary lower right canine tooth",
      "definition" : "Deciduous mandibular right canine tooth; Universal designation R; ISO designation 83",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23842"
        }
      ]
    },
    {
      "code" : "161941D",
      "display" : "Permanent upper right lateral incisor tooth",
      "definition" : "Permanent maxillary right lateral incisor tooth; Universal designation 7; ISO designation 12",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23799"
        }
      ]
    },
    {
      "code" : "161956D",
      "display" : "Primary lower right lateral incisor tooth",
      "definition" : "Deciduous mandibular right lateral incisor tooth; Universal designation Q; ISO designation 82",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23841"
        }
      ]
    },
    {
      "code" : "162004D",
      "display" : "Primary upper left first molar tooth",
      "definition" : "Deciduous maxillary left first molar tooth; Universal designation I; ISO designation 64",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23833"
        }
      ]
    },
    {
      "code" : "162062D",
      "display" : "Primary lower right central incisor tooth",
      "definition" : "Deciduous mandibular right central incisor tooth; Universal designation P; ISO designation 81",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23840"
        }
      ]
    },
    {
      "code" : "162091D",
      "display" : "Primary upper right second molar tooth",
      "definition" : "Deciduous maxillary right second molar tooth; Universal designation A; ISO designation 55",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23825"
        }
      ]
    },
    {
      "code" : "162129D",
      "display" : "Primary lower left lateral incisor tooth",
      "definition" : "Deciduous mandibular left lateral incisor tooth; Universal designation N; ISO designation 72",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23838"
        }
      ]
    },
    {
      "code" : "162206D",
      "display" : "Primary lower right first molar tooth",
      "definition" : "Deciduous mandibular right first molar tooth: Universal designation S; ISO designation 84",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23843"
        }
      ]
    },
    {
      "code" : "162234D",
      "display" : "Primary upper right first molar tooth",
      "definition" : "Deciduous maxillary right first molar tooth; Universal designation B; ISO designation 54",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23826"
        }
      ]
    },
    {
      "code" : "162268D",
      "display" : "Primary upper right canine tooth",
      "definition" : "Deciduous maxillary right canine tooth; Universal designation C; ISO designation 53",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23827"
        }
      ]
    },
    {
      "code" : "162309D",
      "display" : "Primary upper left canine tooth",
      "definition" : "Deciduous maxillary left canine tooth; Universal designation H; ISO designation 63",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23832"
        }
      ]
    },
    {
      "code" : "162321D",
      "display" : "Primary lower left second molar tooth",
      "definition" : "Deciduous mandibular left second molar tooth; Universal designation K; ISO designation 75",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23835"
        }
      ]
    },
    {
      "code" : "162345D",
      "display" : "Primary lower left central incisor tooth",
      "definition" : "Deciduous mandibular left central incisor tooth: Universal designation O; ISO designation 71",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23839"
        }
      ]
    },
    {
      "code" : "162350D",
      "display" : "Primary upper left lateral incisor tooth",
      "definition" : "Deciduous maxillary left lateral incisor tooth; Universal designation G; ISO designation 62",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23831"
        }
      ]
    },
    {
      "code" : "162418D",
      "display" : "Primary upper left central incisor tooth",
      "definition" : "Deciduous maxillary left central incisor tooth; Universal designation F; ISO designation 61",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23830"
        }
      ]
    },
    {
      "code" : "162425D",
      "display" : "Primary lower right second molar tooth",
      "definition" : "Deciduous mandibular right second molar tooth; Universal designation T; ISO designation 85",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23844"
        }
      ]
    },
    {
      "code" : "162441D",
      "display" : "Primary lower left canine tooth",
      "definition" : "Deciduous mandibular left canine tooth; Universal designation M; ISO designation 73",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23837"
        }
      ]
    },
    {
      "code" : "162494D",
      "display" : "Primary upper right lateral incisor tooth",
      "definition" : "Deciduous maxillary right lateral incisor tooth; Universal designation D; ISO designation 52",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23828"
        }
      ]
    },
    {
      "code" : "162537D",
      "display" : "Primary lower left first molar tooth",
      "definition" : "Deciduous mandibular left first molar tooth; Universal designation L; ISO designation 74",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23836"
        }
      ]
    },
    {
      "code" : "162585D",
      "display" : "Primary upper left second molar tooth",
      "definition" : "Deciduous maxillary left second molar tooth; Universal designation J; ISO designation 65",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23834"
        }
      ]
    },
    {
      "code" : "162619D",
      "display" : "Primary upper right central incisor tooth",
      "definition" : "Deciduous maxillary right central incisor tooth; Universal designation E; ISO designation 51",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23829"
        }
      ]
    },
    {
      "code" : "163013D",
      "display" : "Mesial-lingual",
      "definition" : "The mesial lingual aspect of the tooth.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23852"
        }
      ]
    },
    {
      "code" : "163468D",
      "display" : "Distal-lingual",
      "definition" : "The distal lingual aspect of the tooth.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23853"
        }
      ]
    },
    {
      "code" : "163596D",
      "display" : "Distal-buccal",
      "definition" : "The distal buccal aspect of the tooth.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23858"
        }
      ]
    },
    {
      "code" : "163680D",
      "display" : "Mesial-buccal",
      "definition" : "The mesial buccal aspect of the tooth.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23860"
        }
      ]
    },
    {
      "code" : "177259D",
      "display" : "Supernumerary permanent maxillary right central incisor tooth",
      "definition" : "Supernumerary permanent maxillary right central incisor tooth; Universal designation 58",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23988"
        }
      ]
    },
    {
      "code" : "177263D",
      "display" : "Supernumerary deciduous maxillary left lateral incisor tooth",
      "definition" : "Supernumerary deciduous maxillary left lateral incisor tooth; Universal designation GS",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23956"
        }
      ]
    },
    {
      "code" : "177271D",
      "display" : "Supernumerary permanent mandibular left lateral incisor tooth",
      "definition" : "Supernumerary permanent mandibular left lateral incisor tooth; Universal designation 73",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23967"
        }
      ]
    },
    {
      "code" : "177285D",
      "display" : "Supernumerary permanent mandibular right central incisor tooth",
      "definition" : "Supernumerary permanent mandibular right central incisor tooth; Universal designation 75",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23972"
        }
      ]
    },
    {
      "code" : "177292D",
      "display" : "Supernumerary deciduous mandibular left central incisor tooth",
      "definition" : "Supernumerary deciduous mandibular left central incisor tooth; Universal designation OS",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23944"
        }
      ]
    },
    {
      "code" : "177302D",
      "display" : "Supernumerary deciduous mandibular right second molar tooth",
      "definition" : "Supernumerary deciduous mandibular right second molar tooth; Universal designation TS",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23952"
        }
      ]
    },
    {
      "code" : "177318D",
      "display" : "Supernumerary deciduous mandibular left lateral incisor tooth",
      "definition" : "Supernumerary deciduous mandibular left lateral incisor tooth; Universal designation NS",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23946"
        }
      ]
    },
    {
      "code" : "177325D",
      "display" : "Supernumerary permanent maxillary left second premolar tooth",
      "definition" : "Supernumerary permanent maxillary left second premolar tooth; Universal designation 63",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23985"
        }
      ]
    },
    {
      "code" : "177339D",
      "display" : "Supernumerary permanent maxillary right canine tooth",
      "definition" : "Supernumerary permanent maxillary right canine tooth; Universal designation 56",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23987"
        }
      ]
    },
    {
      "code" : "177341D",
      "display" : "Supernumerary permanent mandibular right canine tooth",
      "definition" : "Supernumerary permanent mandibular right canine tooth; Universal designation 77",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23971"
        }
      ]
    },
    {
      "code" : "177356D",
      "display" : "Supernumerary permanent maxillary left canine tooth",
      "definition" : "Supernumerary permanent maxillary left canine tooth; Universal designation 61",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23979"
        }
      ]
    },
    {
      "code" : "177360D",
      "display" : "Supernumerary deciduous maxillary right first molar tooth",
      "definition" : "Supernumerary deciduous maxillary right first molar tooth; Universal designation BS",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23960"
        }
      ]
    },
    {
      "code" : "177373D",
      "display" : "Supernumerary permanent maxillary left second molar tooth",
      "definition" : "Supernumerary permanent maxillary left second molar tooth; Universal designation 65",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23984"
        }
      ]
    },
    {
      "code" : "177387D",
      "display" : "Supernumerary deciduous mandibular right canine tooth",
      "definition" : "Supernumerary deciduous mandibular right canine tooth; Universal designation RS",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23948"
        }
      ]
    },
    {
      "code" : "177394D",
      "display" : "Supernumerary permanent maxillary right third molar tooth",
      "definition" : "Supernumerary permanent maxillary right third molar tooth; Universal designation 51",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23994"
        }
      ]
    },
    {
      "code" : "177409D",
      "display" : "Supernumerary permanent mandibular right second premolar tooth",
      "definition" : "Supernumerary permanent mandibular right second premolar tooth; Universal designation 79",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23977"
        }
      ]
    },
    {
      "code" : "177413D",
      "display" : "Supernumerary permanent mandibular right first molar tooth",
      "definition" : "Supernumerary permanent mandibular right first molar tooth; Universal designation 80",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23973"
        }
      ]
    },
    {
      "code" : "177421D",
      "display" : "Supernumerary deciduous mandibular left first molar tooth",
      "definition" : "Supernumerary deciduous mandibular left first molar tooth; Universal designation LS",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23945"
        }
      ]
    },
    {
      "code" : "177432D",
      "display" : "Supernumerary permanent mandibular right second molar tooth",
      "definition" : "Supernumerary permanent mandibular right second molar tooth; Universal designation 81",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23976"
        }
      ]
    },
    {
      "code" : "177445D",
      "display" : "Supernumerary permanent maxillary left first premolar tooth",
      "definition" : "Supernumerary permanent maxillary left first premolar tooth; Universal designation 62",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23982"
        }
      ]
    },
    {
      "code" : "177450D",
      "display" : "Supernumerary deciduous mandibular right central incisor tooth",
      "definition" : "Supernumerary deciduous mandibular right central incisor tooth; Universal designation PS",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23949"
        }
      ]
    },
    {
      "code" : "177466D",
      "display" : "Supernumerary deciduous mandibular right lateral incisor tooth",
      "definition" : "Supernumerary deciduous mandibular right lateral incisor tooth; Universal designation QS",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23951"
        }
      ]
    },
    {
      "code" : "177478D",
      "display" : "Supernumerary permanent mandibular left first molar tooth",
      "definition" : "Supernumerary permanent mandibular left first molar tooth; Universal designation 69",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23965"
        }
      ]
    },
    {
      "code" : "177484D",
      "display" : "Supernumerary permanent maxillary right lateral incisor tooth",
      "definition" : "Supernumerary permanent maxillary right lateral incisor tooth; Universal designation 57",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23991"
        }
      ]
    },
    {
      "code" : "177497D",
      "display" : "Supernumerary deciduous maxillary left canine tooth",
      "definition" : "Supernumerary deciduous maxillary left canine tooth; Universal designation HS",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23953"
        }
      ]
    },
    {
      "code" : "177506D",
      "display" : "Supernumerary permanent mandibular right lateral incisor tooth",
      "definition" : "Supernumerary permanent mandibular right lateral incisor tooth; Universal designation 76",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23975"
        }
      ]
    },
    {
      "code" : "177510D",
      "display" : "Supernumerary permanent mandibular left central incisor tooth",
      "definition" : "Supernumerary permanent mandibular left central incisor tooth; Universal designation 74",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23964"
        }
      ]
    },
    {
      "code" : "177523D",
      "display" : "Supernumerary permanent mandibular left canine tooth",
      "definition" : "Supernumerary permanent mandibular left canine tooth; Universal designation 72",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23963"
        }
      ]
    },
    {
      "code" : "177534D",
      "display" : "Supernumerary permanent maxillary right first molar tooth",
      "definition" : "Supernumerary permanent maxillary right first molar tooth; Universal designation 53",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23989"
        }
      ]
    },
    {
      "code" : "177547D",
      "display" : "Supernumerary permanent maxillary right second premolar tooth",
      "definition" : "Supernumerary permanent maxillary right second premolar tooth; Universal designation 54",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23993"
        }
      ]
    },
    {
      "code" : "177552D",
      "display" : "Supernumerary deciduous mandibular left canine tooth",
      "definition" : "Supernumerary deciduous mandibular left canine tooth; Universal designation MS",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23943"
        }
      ]
    },
    {
      "code" : "177568D",
      "display" : "Supernumerary permanent maxillary left third molar tooth",
      "definition" : "Supernumerary permanent maxillary left third molar tooth; Universal designation 66",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23986"
        }
      ]
    },
    {
      "code" : "177575D",
      "display" : "Supernumerary deciduous maxillary right canine tooth",
      "definition" : "Supernumerary deciduous maxillary right canine tooth; Universal designation CS",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23958"
        }
      ]
    },
    {
      "code" : "177581D",
      "display" : "Supernumerary deciduous maxillary left second molar tooth",
      "definition" : "Supernumerary deciduous maxillary left second molar tooth; Universal designation JS",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23957"
        }
      ]
    },
    {
      "code" : "177599D",
      "display" : "Supernumerary permanent mandibular right first premolar tooth",
      "definition" : "Supernumerary permanent mandibular right first premolar tooth; Universal designation 78",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23974"
        }
      ]
    },
    {
      "code" : "177608D",
      "display" : "Supernumerary permanent mandibular right third molar tooth",
      "definition" : "Supernumerary permanent mandibular right third molar tooth; Universal designation 82",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23978"
        }
      ]
    },
    {
      "code" : "177612D",
      "display" : "Supernumerary permanent maxillary right first premolar tooth",
      "definition" : "Supernumerary permanent maxillary right first premolar tooth; Universal designation 55",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23990"
        }
      ]
    },
    {
      "code" : "177620D",
      "display" : "Supernumerary deciduous maxillary right lateral incisor tooth",
      "definition" : "Supernumerary deciduous maxillary right lateral incisor tooth; Universal designation DS",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23961"
        }
      ]
    },
    {
      "code" : "177631D",
      "display" : "Supernumerary permanent mandibular left first premolar tooth",
      "definition" : "Supernumerary permanent mandibular left first premolar tooth ; Universal designation 71",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23966"
        }
      ]
    },
    {
      "code" : "177649D",
      "display" : "Supernumerary permanent maxillary right second molar tooth",
      "definition" : "Supernumerary permanent maxillary right second molar tooth; Universal designation 52",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23992"
        }
      ]
    },
    {
      "code" : "177654D",
      "display" : "Supernumerary permanent maxillary left first molar tooth",
      "definition" : "Supernumerary permanent maxillary left first molar tooth; Universal designation 64",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23981"
        }
      ]
    },
    {
      "code" : "177665D",
      "display" : "Supernumerary deciduous maxillary right second molar tooth",
      "definition" : "Supernumerary deciduous maxillary right second molar tooth; Universal designation AS",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23962"
        }
      ]
    },
    {
      "code" : "177677D",
      "display" : "Supernumerary permanent mandibular left second molar tooth",
      "definition" : "Supernumerary permanent mandibular left second molar tooth; Universal designation 68",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23968"
        }
      ]
    },
    {
      "code" : "177683D",
      "display" : "Supernumerary permanent maxillary left lateral incisor tooth",
      "definition" : "Supernumerary permanent maxillary left lateral incisor tooth; Universal designation 60",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23983"
        }
      ]
    },
    {
      "code" : "177696D",
      "display" : "Supernumerary deciduous maxillary right central incisor tooth",
      "definition" : "Supernumerary deciduous maxillary right central incisor tooth; Universal designation ES",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23959"
        }
      ]
    },
    {
      "code" : "177704D",
      "display" : "Supernumerary deciduous mandibular left second molar tooth",
      "definition" : "Supernumerary deciduous mandibular left second molar tooth ; Universal designation KS",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23947"
        }
      ]
    },
    {
      "code" : "177715D",
      "display" : "Supernumerary deciduous maxillary left first molar tooth",
      "definition" : "Supernumerary deciduous maxillary left first molar tooth; Universal designation IS",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23955"
        }
      ]
    },
    {
      "code" : "177727D",
      "display" : "Supernumerary permanent mandibular left second premolar tooth",
      "definition" : "Supernumerary permanent mandibular left second premolar tooth; Universal designation 70",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23969"
        }
      ]
    },
    {
      "code" : "177736D",
      "display" : "Supernumerary deciduous maxillary left central incisor tooth",
      "definition" : "Supernumerary deciduous maxillary left central incisor tooth; Universal designation FS",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23954"
        }
      ]
    },
    {
      "code" : "177743D",
      "display" : "Supernumerary permanent mandibular left third molar tooth",
      "definition" : "Supernumerary permanent mandibular left third molar tooth; Universal designation 67",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23970"
        }
      ]
    },
    {
      "code" : "177758D",
      "display" : "Supernumerary deciduous mandibular right first molar tooth",
      "definition" : "Supernumerary deciduous mandibular right first molar tooth; Universal designation SS",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23950"
        }
      ]
    },
    {
      "code" : "177762D",
      "display" : "Supernumerary permanent maxillary left central incisor tooth",
      "definition" : "Supernumerary permanent maxillary left central incisor tooth; Universal designation 59",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23980"
        }
      ]
    },
    {
      "code" : "197703D",
      "display" : "Overjet",
      "definition" : "Overjet",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "24033"
        }
      ]
    },
    {
      "code" : "198545D",
      "display" : "Complete trisomy 21 syndrome",
      "definition" : "Complete trisomy 21 syndrome",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "24016"
        }
      ]
    },
    {
      "code" : "199380D",
      "display" : "Marfan syndrome",
      "definition" : "Marfan syndrome",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "24017"
        }
      ]
    },
    {
      "code" : "209615D",
      "display" : "Lower labial frenum",
      "definition" : "The folds of mucous membrane extending from the gingiva to the midline of the lower lip.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23854"
        }
      ]
    },
    {
      "code" : "209620D",
      "display" : "Upper labial frenum",
      "definition" : "The folds of mucous membrane extending from the gingiva to the midline of the upper lip.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23855"
        }
      ]
    },
    {
      "code" : "209631D",
      "display" : "Upper buccal frenum",
      "definition" : "A fold or band of mucous membrane connecting the upper alveolar ridge to the cheek and separating the labial vestibule from the buccal vestibule",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23856"
        }
      ]
    },
    {
      "code" : "209645D",
      "display" : "Lower buccal frenum",
      "definition" : "A fold or band of mucous membrane connecting the lower alveolar ridge to the cheek and separating the labial vestibule from the buccal vestibule",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23857"
        }
      ]
    },
    {
      "code" : "210116D",
      "display" : "Active dental caries",
      "definition" : "Active dental caries",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23997"
        }
      ]
    },
    {
      "code" : "210952D",
      "display" : "Deep impinging overbite with soft tissue destruction",
      "definition" : "Deep impinging overbite with soft tissue destruction",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23999"
        }
      ]
    },
    {
      "code" : "210953D",
      "display" : "Anterior crossbite with destruction of oral mucosa",
      "definition" : "Anterior crossbite with destruction of oral mucosa",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "24000"
        }
      ]
    },
    {
      "code" : "210954D",
      "display" : "Lip incompetence due to horizontal overbite",
      "definition" : "Lip incompetence due to horizontal overbite",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "24001"
        }
      ]
    },
    {
      "code" : "210955D",
      "display" : "Posterior crossbite limited to left side",
      "definition" : "Posterior crossbite limited to left side",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "24002"
        }
      ]
    },
    {
      "code" : "210956D",
      "display" : "Posterior crossbite limited to right side",
      "definition" : "Posterior crossbite limited to right side",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "24003"
        }
      ]
    },
    {
      "code" : "210957D",
      "display" : "Articulatory defect secondary to dental defect",
      "definition" : "Articulatory defect secondary to dental defect",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "24006"
        }
      ]
    },
    {
      "code" : "210958D",
      "display" : "Cleft lip & alveolus",
      "definition" : "Cleft lip & alveolus",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "24009"
        }
      ]
    },
    {
      "code" : "210959D",
      "display" : "Craniosynostosis syndrome",
      "definition" : "Craniosynostosis syndrome",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "24012"
        }
      ]
    },
    {
      "code" : "210960D",
      "display" : "Arthrogryposis",
      "definition" : "Arthrogryposis",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "24015"
        }
      ]
    },
    {
      "code" : "210962D",
      "display" : "Mixed Dentition",
      "definition" : "Mixed Dentition",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "24025"
        }
      ]
    },
    {
      "code" : "210963D",
      "display" : "Anterior segment of maxilla",
      "definition" : "Anterior segment of maxilla",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "24029"
        }
      ]
    },
    {
      "code" : "210964D",
      "display" : "Posterior segment of maxilla",
      "definition" : "Posterior segment of maxilla",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "24030"
        }
      ]
    },
    {
      "code" : "210965D",
      "display" : "Anterior part of lower alveolar ridge",
      "definition" : "Anterior part of lower alveolar ridge",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "24031"
        }
      ]
    },
    {
      "code" : "210966D",
      "display" : "Posterior part of lower alveolar ridge",
      "definition" : "Posterior part of lower alveolar ridge",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "24032"
        }
      ]
    },
    {
      "code" : "210967D",
      "display" : "Overbite",
      "definition" : "Overbite",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "24034"
        }
      ]
    },
    {
      "code" : "210972D",
      "display" : "Anterior deviation of posterior interarch",
      "definition" : "Anterior deviation of posterior interarch",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "24037"
        }
      ]
    },
    {
      "code" : "210974D",
      "display" : "Posterior deviation of posterior interarch",
      "definition" : "Posterior deviation of posterior interarch",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "24038"
        }
      ]
    }
  ]
}

```
