# QueryStatusCode - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **QueryStatusCode**

## CodeSystem: QueryStatusCode 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-QueryStatusCode | *Version*:3.0.0 | |
| Active as of 2019-03-20 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:QueryStatusCode |
| *Other Identifiers:*OID:2.16.840.1.113883.5.103 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
A code specifying the state of the Query. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [QueryStatusCode](ValueSet-v3-QueryStatusCode.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-QueryStatusCode",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-QueryStatusCode",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.103"
    }
  ],
  "version" : "3.0.0",
  "name" : "QueryStatusCode",
  "title" : "QueryStatusCode",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "A code specifying the state of the Query.",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state. Normally is not populated unless the state is retired.",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "aborted",
      "display" : "aborted",
      "definition" : "Query status aborted",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19301"
        }
      ]
    },
    {
      "code" : "deliveredResponse",
      "display" : "deliveredResponse",
      "definition" : "Query Status delivered response",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19302"
        }
      ]
    },
    {
      "code" : "executing",
      "display" : "executing",
      "definition" : "Query Status executing",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19303"
        }
      ]
    },
    {
      "code" : "new",
      "display" : "new",
      "definition" : "Query Status new",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19304"
        }
      ]
    },
    {
      "code" : "waitContinuedQueryResponse",
      "display" : "waitContinuedQueryResponse",
      "definition" : "Query Status wait continued",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19305"
        }
      ]
    }
  ]
}

```
