# ParameterizedDataType - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ParameterizedDataType**

## CodeSystem: ParameterizedDataType 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-ParameterizedDataType | *Version*:2.0.1 | |
| Retired as of 2019-03-20 | *Responsible:*Health Level 7 | *Computable Name*:ParameterizedDataType |
| *Other Identifiers:*OID:2.16.840.1.113883.5.87 | | |

 
**Deprecation Comment:**Deprecated as per 11/2008 Harmonization cleanup; internal and obsolete HL7 usage, no longer used. 

 This Code system is referenced in the content logical definition of the following value sets: 

* This CodeSystem is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-ParameterizedDataType",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-ParameterizedDataType",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.87"
    }
  ],
  "version" : "2.0.1",
  "name" : "ParameterizedDataType",
  "title" : "ParameterizedDataType",
  "status" : "retired",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "Health Level 7",
  "contact" : [
    {
      "name" : "Health Level Seven"
    }
  ],
  "description" : "**Deprecation Comment:** Deprecated as per 11/2008 Harmonization cleanup; internal and obsolete HL7 usage, no longer used.",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state. Normally is not populated unless the state is retired.",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "BAG<T>",
      "display" : "Bag",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10763"
        }
      ]
    },
    {
      "code" : "LIST<T>",
      "display" : "Sequence",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10762"
        }
      ]
    },
    {
      "code" : "SET<T>",
      "display" : "Set",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10761"
        }
      ],
      "concept" : [
        {
          "code" : "EIVL<T>",
          "display" : "Event Related Interval",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "10766"
            }
          ]
        },
        {
          "code" : "IVL<T>",
          "display" : "Interval",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "10764"
            }
          ]
        },
        {
          "code" : "PIVL<T>",
          "display" : "Periodic Interval",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "10765"
            }
          ]
        }
      ]
    },
    {
      "code" : "T",
      "display" : "Type",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10760"
        }
      ],
      "concept" : [
        {
          "code" : "ANT<T>",
          "display" : "Annotated",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "10767"
            }
          ]
        },
        {
          "code" : "HXIT<T>",
          "display" : "Historical",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "10768"
            }
          ]
        },
        {
          "code" : "NPPD<T>",
          "display" : "Non Parametric Probability Distribution",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "10771"
            }
          ]
        },
        {
          "code" : "PPD<T>",
          "display" : "Parametric Probability Distribution",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "10772"
            }
          ]
        },
        {
          "code" : "UVN<T>",
          "display" : "Uncertain Value Narrative",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "10769"
            }
          ]
        },
        {
          "code" : "UVP<T>",
          "display" : "Uncertain Value Probabilistic",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "10770"
            }
          ]
        }
      ]
    }
  ]
}

```
