# ActInvoiceElementModifier - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ActInvoiceElementModifier**

## CodeSystem: ActInvoiceElementModifier 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-ActInvoiceElementModifier | *Version*:3.0.0 | |
| Active as of 2019-03-20 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ActInvoiceElementModifier |
| *Other Identifiers:*OID:2.16.840.1.113883.5.1051 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Processing consideration and clarification codes. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ActInvoiceElementModifier](ValueSet-v3-ActInvoiceElementModifier.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-ActInvoiceElementModifier",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-ActInvoiceElementModifier",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.1051"
    }
  ],
  "version" : "3.0.0",
  "name" : "ActInvoiceElementModifier",
  "title" : "ActInvoiceElementModifier",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Processing consideration and clarification codes.",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state. Normally is not populated unless the state is retired.",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "EFORM",
      "display" : "Electronic Form To Follow",
      "definition" : "Electronic form with supporting information to follow.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "17706"
        }
      ]
    },
    {
      "code" : "FAX",
      "display" : "Fax To Follow",
      "definition" : "Fax with supporting information to follow.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "17707"
        }
      ]
    },
    {
      "code" : "LINV",
      "display" : "Last Invoice",
      "definition" : "Represents the last invoice from the perspective of the provider.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "17708"
        }
      ]
    },
    {
      "code" : "PAPER",
      "display" : "Paper Documentation To Follow",
      "definition" : "Paper documentation (or other physical format) with supporting information to follow.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "17705"
        }
      ]
    }
  ]
}

```
