# processInterruption - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **processInterruption**

## CodeSystem: processInterruption 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0923 | *Version*:3.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ProcessInterruption |
| *Other Identifiers:*OID:2.16.840.1.113883.18.429 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
HL7-defined code system of concepts specifying whether the process was interrrupted and whether the needle had been inserted in the donor's arm prior to the interruption. Used in HL7 Version 2.x messaging in the DON segment. 

 
Underlying Master Code System for V2 table 0923 (Process Interruption) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSProcessInterruption](ValueSet-v2-0923.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0923",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "oo"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0923",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.429"
    }
  ],
  "version" : "3.0.0",
  "name" : "ProcessInterruption",
  "title" : "processInterruption",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts specifying whether the process was interrrupted and whether the needle had been inserted in the donor's arm prior to the interruption.  Used in HL7 Version 2.x messaging in the DON segment.",
  "purpose" : "Underlying Master Code System for V2 table 0923 (Process Interruption)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0923",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "id" : "6644",
      "code" : "NIN",
      "display" : "Process was not interrupted",
      "definition" : "Process was not interrupted",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6645",
      "code" : "WOT",
      "display" : "Walk Out: Process interrupted before the Phlebotomist inserts the needle in the Donor's arm",
      "definition" : "Walk Out: Process interrupted before the Phlebotomist inserts the needle in the Donor's arm",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6646",
      "code" : "ABR",
      "display" : "Aborted Run: Process interrupted after the Phlebotomist inserts the needle in the Donor's arm",
      "definition" : "Aborted Run: Process interrupted after the Phlebotomist inserts the needle in the Donor's arm",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
