# grouperStatus - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **grouperStatus**

## CodeSystem: grouperStatus 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0734 | *Version*:3.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:GrouperStatus |
| *Other Identifiers:*OID:2.16.840.1.113883.18.393 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Code system of concepts specifying the status of a grouper in general. US Realm. Used in HL7 Version 2.x messaging in the DRG segment. 

 
Underlying Master Code System for V2 table 0734 (Grouper Status) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSGrouperStatus](ValueSet-v2-0734.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0734",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0734",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.393"
    }
  ],
  "version" : "3.0.0",
  "name" : "GrouperStatus",
  "title" : "grouperStatus",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts specifying the status of a grouper in general.  US Realm. Used in HL7 Version 2.x messaging in the DRG segment.",
  "purpose" : "Underlying Master Code System for V2 table 0734 (Grouper Status)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0734",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "id" : "6430",
      "code" : "0",
      "display" : "Normal grouping",
      "definition" : "Normal grouping",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6431",
      "code" : "1",
      "display" : "Invalid or missing primary diagnosis",
      "definition" : "Invalid or missing primary diagnosis",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6432",
      "code" : "2",
      "display" : "Diagnosis is not allowed to be primary",
      "definition" : "Diagnosis is not allowed to be primary",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6433",
      "code" : "3",
      "display" : "Data does not fulfill DRG criteria",
      "definition" : "Data does not fulfill DRG criteria",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6434",
      "code" : "4",
      "display" : "Invalid age, admission date, date of birth or discharge date",
      "definition" : "Invalid age, admission date, date of birth or discharge date",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6435",
      "code" : "5",
      "display" : "Invalid gender",
      "definition" : "Invalid gender",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6436",
      "code" : "6",
      "display" : "Invalid discharge status",
      "definition" : "Invalid discharge status",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6437",
      "code" : "7",
      "display" : "Invalid weight ad admission",
      "definition" : "Invalid weight ad admission",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6438",
      "code" : "8",
      "display" : "Invalid length of stay",
      "definition" : "Invalid length of stay",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6439",
      "code" : "9",
      "display" : "Invalid field \"same day\"",
      "definition" : "Invalid field \"same day\"",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
