# itemStatus - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **itemStatus**

## CodeSystem: itemStatus 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0625 | *Version*:3.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ItemStatus |
| *Other Identifiers:*OID:2.16.840.1.113883.18.377 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Code system of concepts that identify the state of an inventory item within the context of an inventory location. Used in HL7 Version 2.x messaging in the IVT segment. 

 
Underlying Master Code System for V2 table 0625 (Item Status Codes) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSItemStatusCodes](ValueSet-v2-0625.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0625",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "oo"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0625",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.377"
    }
  ],
  "version" : "3.0.0",
  "name" : "ItemStatus",
  "title" : "itemStatus",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts that identify the state of an inventory item within the context of an inventory location. Used in HL7 Version 2.x messaging in the IVT segment.",
  "purpose" : "Underlying Master Code System for V2 table 0625 (Item Status Codes)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0625",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    },
    {
      "code" : "v2-concComment",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-concComment",
      "description" : "V2 Concept Comment",
      "type" : "string"
    },
    {
      "code" : "v2-concCommentAsPub",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-concCommentAsPub",
      "description" : "V2 Concept Comment As Published",
      "type" : "string"
    }
  ],
  "concept" : [
    {
      "id" : "6265",
      "code" : "1",
      "display" : "Active",
      "definition" : "Active",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Item is available to be purchased or issued."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Item is available to be purchased or issued."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6266",
      "code" : "2",
      "display" : "Pending Inactive",
      "definition" : "Pending Inactive",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Item is not available to be purchased, but is available to be issued."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Item is not available to be purchased, but is available to be issued."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6267",
      "code" : "3",
      "display" : "Inactive",
      "definition" : "Inactive",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Item is not available to be purchased or issued."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Item is not available to be purchased or issued."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
