# providerAdjustmentReason - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **providerAdjustmentReason**

## CodeSystem: providerAdjustmentReason 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0565 | *Version*:3.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ProviderAdjustmentReason |
| *Other Identifiers:*OID:2.16.840.1.113883.18.367 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Code system of concepts used to specify the reason for this adjustment. Used in the Adjustment (ADJ) segment in HL7 Version 2.x messaging. 

 
Underlying Master Code System for V2 table 0565 (Provider Adjustment Reason Code) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSProviderAdjustmentReasonCode](ValueSet-v2-0565.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0565",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0565",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.367"
    }
  ],
  "version" : "3.0.0",
  "name" : "ProviderAdjustmentReason",
  "title" : "providerAdjustmentReason",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts used to specify the reason for this adjustment.  Used in the Adjustment (ADJ) segment in HL7 Version 2.x messaging.",
  "purpose" : "Underlying Master Code System for V2 table 0565 (Provider Adjustment Reason Code)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0565",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "id" : "6211",
      "code" : "PST",
      "display" : "Provincial Sales Tax",
      "definition" : "Provincial Sales Tax",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6212",
      "code" : "GST",
      "display" : "Goods and Services Tax",
      "definition" : "Goods and Services Tax",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6213",
      "code" : "HST",
      "display" : "Harmonized Sales Tax",
      "definition" : "Harmonized Sales Tax",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6214",
      "code" : "DISP",
      "display" : "Dispensing Fee",
      "definition" : "Dispensing Fee",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6215",
      "code" : "MKUP",
      "display" : "Mark up Fee",
      "definition" : "Mark up Fee",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
