# adjustmentCategory - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **adjustmentCategory**

## CodeSystem: adjustmentCategory 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0564 | *Version*:3.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:AdjustmentCategory |
| *Other Identifiers:*OID:2.16.840.1.113883.18.366 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Code system of concepts used to specify the category of adjustment and is used to assist in determining which table is used for Adjustment Reason. Used in the Adjustment (ADJ) segment in HL7 Version 2.x messaging. 

 
Underlying Master Code System for V2 table 0564 (Adjustment Category Code) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSAdjustmentCategoryCode](ValueSet-v2-0564.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0564",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0564",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.366"
    }
  ],
  "version" : "3.0.0",
  "name" : "AdjustmentCategory",
  "title" : "adjustmentCategory",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts used to specify the category of adjustment and is used to assist in determining which table is used for Adjustment Reason.  Used in the Adjustment (ADJ) segment in HL7 Version 2.x messaging.",
  "purpose" : "Underlying Master Code System for V2 table 0564 (Adjustment Category Code)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0564",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    },
    {
      "code" : "v2-concComment",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-concComment",
      "description" : "V2 Concept Comment",
      "type" : "string"
    },
    {
      "code" : "v2-concCommentAsPub",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-concCommentAsPub",
      "description" : "V2 Concept Comment As Published",
      "type" : "string"
    }
  ],
  "concept" : [
    {
      "id" : "6207",
      "code" : "EA",
      "display" : "Edit/Adjudication Response",
      "definition" : "Edit/Adjudication Response",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Payer adjustment"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Payer adjustment"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6208",
      "code" : "IN",
      "display" : "Information",
      "definition" : "Information",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Payer adjustment"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Payer adjustment"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6209",
      "code" : "PA",
      "display" : "Provider Adjustment",
      "definition" : "Provider Adjustment",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Provider adjustment"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Provider adjustment"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6210",
      "code" : "PR",
      "display" : "Processing Result",
      "definition" : "Processing Result",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Payer adjustment"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Payer adjustment"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
