# informInstructions - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **informInstructions**

## CodeSystem: informInstructions 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0517 | *Version*:3.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:InformInstructions |
| *Other Identifiers:*OID:2.16.840.1.113883.18.338 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Code system of concepts specifying who (if anyone) should or should not be informed of an error. Used in the Error (ERR) segment in HL7 Version 2.x messaging. 

 
Underlying Master Code System for V2 table 0517 (Inform Person Code) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSInformPersonCode](ValueSet-v2-0517.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0517",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "inm"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0517",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.338"
    }
  ],
  "version" : "3.0.0",
  "name" : "InformInstructions",
  "title" : "informInstructions",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts specifying who (if anyone) should or should not be informed of an error.  Used in the Error (ERR) segment in HL7 Version 2.x messaging.",
  "purpose" : "Underlying Master Code System for V2 table 0517 (Inform Person Code)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0517",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "id" : "5590",
      "code" : "PAT",
      "display" : "Inform patient",
      "definition" : "Inform patient",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5591",
      "code" : "NPAT",
      "display" : "Do NOT inform patient",
      "definition" : "Do NOT inform patient",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5592",
      "code" : "USR",
      "display" : "Inform User",
      "definition" : "Inform User",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5593",
      "code" : "HD",
      "display" : "Inform help desk",
      "definition" : "Inform help desk",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
