# documentType - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **documentType**

## CodeSystem: documentType 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0270 | *Version*:3.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:DocumentType |
| *Other Identifiers:*OID:2.16.840.1.113883.18.163 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Code system of concepts used to identify the kind of patient document. Used in HL7 Version 2.x messaging in the TXA segment. 

 
Underlying Master Code System for V2 table 0270 (Document Type) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSReportTypeCode](ValueSet-v2-0270.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0270",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "sd"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0270",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.163"
    }
  ],
  "version" : "3.0.0",
  "name" : "DocumentType",
  "title" : "documentType",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts used to identify the kind of patient document.  Used in HL7 Version 2.x messaging in the TXA segment.",
  "purpose" : "Underlying Master Code System for V2 table 0270 (Document Type)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0270",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "id" : "2631",
      "code" : "AR",
      "display" : "Autopsy report",
      "definition" : "Autopsy report",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2632",
      "code" : "CD",
      "display" : "Cardiodiagnostics",
      "definition" : "Cardiodiagnostics",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2633",
      "code" : "CN",
      "display" : "Consultation",
      "definition" : "Consultation",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2634",
      "code" : "DI",
      "display" : "Diagnostic imaging",
      "definition" : "Diagnostic imaging",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2635",
      "code" : "DS",
      "display" : "Discharge summary",
      "definition" : "Discharge summary",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2636",
      "code" : "ED",
      "display" : "Emergency department report",
      "definition" : "Emergency department report",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2637",
      "code" : "HP",
      "display" : "History and physical examination",
      "definition" : "History and physical examination",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2638",
      "code" : "OP",
      "display" : "Operative report",
      "definition" : "Operative report",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2639",
      "code" : "PC",
      "display" : "Psychiatric consultation",
      "definition" : "Psychiatric consultation",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2640",
      "code" : "PH",
      "display" : "Psychiatric history and physical examination",
      "definition" : "Psychiatric history and physical examination",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2641",
      "code" : "PN",
      "display" : "Procedure note",
      "definition" : "Procedure note",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2642",
      "code" : "PR",
      "display" : "Progress note",
      "definition" : "Progress note",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2643",
      "code" : "SP",
      "display" : "Surgical pathology",
      "definition" : "Surgical pathology",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2644",
      "code" : "TS",
      "display" : "Transfer summary",
      "definition" : "Transfer summary",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
