# actionTakenInResponseToTheEvent - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **actionTakenInResponseToTheEvent**

## CodeSystem: actionTakenInResponseToTheEvent 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0251 | *Version*:3.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ActionTakenInResponseToTheEvent |
| *Other Identifiers:*OID:2.16.840.1.113883.18.146 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
HL7-defined code system of concepts used to define the action taken as a result of an event related to a product issue. Used in HL7 Version 2.x messaging in the PCR segment. 

 
Underlying Master Code System for V2 table 0251 (Action Taken in Response to the Event) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSActionTakenInResponseToTheEvent](ValueSet-v2-0251.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0251",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "oo"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0251",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.146"
    }
  ],
  "version" : "3.0.0",
  "name" : "ActionTakenInResponseToTheEvent",
  "title" : "actionTakenInResponseToTheEvent",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts used to define the action taken as a result of an event related to a product issue.  Used in HL7 Version 2.x messaging in the PCR segment.",
  "purpose" : "Underlying Master Code System for V2 table 0251 (Action Taken in Response to the Event)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0251",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "id" : "2362",
      "code" : "WP",
      "display" : "Product withdrawn permanently",
      "definition" : "Product withdrawn permanently",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2363",
      "code" : "WT",
      "display" : "Product withdrawn temporarily",
      "definition" : "Product withdrawn temporarily",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2364",
      "code" : "DR",
      "display" : "Product dose or frequency of use reduced",
      "definition" : "Product dose or frequency of use reduced",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2365",
      "code" : "DI",
      "display" : "Product dose or frequency of use increased",
      "definition" : "Product dose or frequency of use increased",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2366",
      "code" : "OT",
      "display" : "Other",
      "definition" : "Other",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2367",
      "code" : "N",
      "display" : "None",
      "definition" : "None",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
