# purgeStatus - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **purgeStatus**

## CodeSystem: purgeStatus 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0213 | *Version*:3.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:PurgeStatus |
| *Other Identifiers:*OID:2.16.840.1.113883.18.117 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Code system of concepts used to define the state of a visit relative to its place in a purge workflow. Used in HL7 Version 2.x messaging in the PV2 segment. 

 
Underlying Master Code System for V2 table 0213 (Purge Status Code) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSPurgeStatus](ValueSet-v2-0213.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0213",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pa"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0213",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.117"
    }
  ],
  "version" : "3.0.0",
  "name" : "PurgeStatus",
  "title" : "purgeStatus",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts used to define the state of a visit relative to its place in a purge workflow.  Used in HL7 Version 2.x messaging in the PV2 segment.",
  "purpose" : "Underlying Master Code System for V2 table 0213 (Purge Status Code)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0213",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "id" : "2167",
      "code" : "P",
      "display" : "Marked for purge.  User is no longer able to update the visit.",
      "definition" : "Marked for purge.  User is no longer able to update the visit.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2168",
      "code" : "D",
      "display" : "The visit is marked for deletion and the user cannot enter new data against it.",
      "definition" : "The visit is marked for deletion and the user cannot enter new data against it.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2169",
      "code" : "I",
      "display" : "The visit is marked inactive and the user cannot enter new data against it.",
      "definition" : "The visit is marked inactive and the user cannot enter new data against it.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
