# procedurePractitionerIdentifierCodeType - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **procedurePractitionerIdentifierCodeType**

## CodeSystem: procedurePractitionerIdentifierCodeType 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0133 | *Version*:3.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ProcedurePractitionerIdentifierCodeType |
| *Other Identifiers:*OID:2.16.840.1.113883.18.59 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
HL7-defined table of concepts which specify the different types of practitioners associated with this procedure. This set of codes is known to be incomplete. Note that as of v2.6, this table and the field(s) it was used in was replaced by table 443 used in the ROL segment. Used in Version 2.x messaging in the PR1 segment, but was discontinued as of 2.6; usage replaced with code system 2.16.840.1.113883.18.283 providerRole. 

 
Underlying Master Code System for V2 table 0133 (Procedure Practitioner Identifier Code Type) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSProcedurePractitionerType](ValueSet-v2-0133.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0133",
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0133",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.59"
    }
  ],
  "version" : "3.0.0",
  "name" : "ProcedurePractitionerIdentifierCodeType",
  "title" : "procedurePractitionerIdentifierCodeType",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined table of concepts which specify the different types of practitioners associated with this procedure.   This set of codes is known to be incomplete.  Note that as of v2.6, this table and the field(s) it was used in was replaced by table 443 used in the ROL segment.  Used in Version 2.x messaging in the PR1 segment, but was discontinued as of 2.6; usage replaced with code system 2.16.840.1.113883.18.283 providerRole.",
  "purpose" : "Underlying Master Code System for V2 table 0133 (Procedure Practitioner Identifier Code Type)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0133",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "id" : "1571",
      "code" : "AN",
      "display" : "Anesthesiologist/Anesthetist",
      "definition" : "Anesthesiologist/Anesthetist",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Anästhesist"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1572",
      "code" : "PR",
      "display" : "Procedure MD/ Surgeon",
      "definition" : "Procedure MD/ Surgeon",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "ausführender Arzt (Chirurg)"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1573",
      "code" : "RD",
      "display" : "Radiologist",
      "definition" : "Radiologist",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Radiologe"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1574",
      "code" : "RS",
      "display" : "Resident",
      "definition" : "Resident",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Krankenhausarzt"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1575",
      "code" : "NP",
      "display" : "Nurse Practitioner",
      "definition" : "Nurse Practitioner",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Krankenschwester"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1576",
      "code" : "CM",
      "display" : "Certified Nurse Midwife",
      "definition" : "Certified Nurse Midwife",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Hebamme"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1577",
      "code" : "SN",
      "display" : "Scrub Nurse",
      "definition" : "Scrub Nurse",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1578",
      "code" : "PS",
      "display" : "Primary Surgeon",
      "definition" : "Primary Surgeon",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "verantwortlicher Chirurg"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1579",
      "code" : "AS",
      "display" : "Assistant Surgeon",
      "definition" : "Assistant Surgeon",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Assistenzchirurg"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
