# Time Period Ranges - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Time Period Ranges**

## CodeSystem: Time Period Ranges 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/time-period-ranges | *Version*:1.0.0 | |
| Active as of 2025-06-27 | *Responsible:*[HL7 International Clinical Quality Information Work Group](http://hl7.org/Special/committees/cqi) | *Computable Name*:TimePeriodRanges |
| **Copyright/Legal**: Adapted from content published by IHE Copyright (c) 2015[IHE International, Inc](http://www.ihe.net/Governance/#Intellectual_Property). Used here according to the terms of the[CC BY 4 License](https://creativecommons.org/licenses/by/4.0/). This CodeSystem constitutes a profile on[ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html), specifying use of its duration definitions for expressing time period ranges. | | |

 
Defines codes for the representation of time period (e.g. age) ranges that are unambiguous, human readable, and machine-readable as a compositional grammar (i.e. the code system defines rules for constructing codes, rather than explicitly enumerating all possible codes). This CodeSystem profiles[ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html)for expressing time period ranges through two simple durations (as defined in the[ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html)specification). 
Codes in the code system are defined according to the grammar: 
A time period (e.g. age) range is defined as two durations:`[duration1]--[duration2]`, where`duration1`specifies the lower inclusive bound of the age range (everyone who is this age and above) and`duration2`specifies the upper exclusive bound of the age range. 
For example, the age range "1-9 years" means everyone who is at least one year old and less than 10 years old represented as`P1Y--P10Y`. The age range "10-14 years" means everyone who is at least 10 years old and less than 15 years old and is represented as`P10Y--P15Y`. 
Durations define the amount of time between two time points. These durations are represented in the form`P[n]Y[n]M[n]DT[n]H[n]M[n]S`or`P[n]W`. The`[n]`is replaced by the value for each of the time elements that follow the`[n]`and the letters have the meaning: 
* `P` is the duration designator (for period) placed at the start of the duration representation. 
* `Y` is the year designator that follows the value for the number of years.
* `M` is the month designator that follows the value for the number of months.
* `W` is the week designator that follows the value for the number of weeks.
* `D` is the day designator that follows the value for the number of days.
 
* `T` is the time designator that precedes the time components of the representation. 
* `H` is the hour designator that follows the value for the number of hours.
* `M` is the minute designator that follows the value for the number of minutes.
* `S` is the second designator that follows the value for the number of seconds. (Note that seconds can be a decimal in this format to allow for milliseconds)
 
 
For example,`P3Y6M4DT12H30M5S`represents a duration of**three years, six months, four days, twelve hours, thirty minutes, and five seconds**. 
Date and time elements including their designator may be omitted if their value is zero, and lower-order elements may also be omitted for reduced precision. For example,`P23DT23H`and`P4Y`are both acceptable duration representations. However, at least one element must be present, thus`P`is not a valid representation for a duration of**0 seconds**.`PT0S`or`P0D`, however, are both valid and represent the same duration. 
Note that the designator`M`is used for both months and minutes, but this is not ambiguous because the minutes designator must be preceded by the time designator`T`. For example`P1M`is**one month**, while`PT1M`is**one minute**. 
Content for this code system is adapted from the definition in the IHE-ADX profile: https://www.ihe.net/uploadedFiles/Documents/QRPH/IHE_QRPH_Suppl_ADX.pdf (Appendix 8K Representation of Age Groups in ADX). In addition, the code system definition is adapted from similar content published as part of the SANER implementation guide. See[Age Range Coding System](https://hl7.org/fhir/uv/saner/CodeSystem-IHE-ADX-agerange.html). 

 
This code system is defined to support consistent, unambiguous, human- and machine-readable representations of time period ranges. A primary intended use case is to support the specification of value sets of age ranges for the purposes of data stratification (also referred to as disaggregation). 

 This Code system is referenced in the content logical definition of the following value sets: 

* [TimePeriodRanges](ValueSet-time-period-ranges.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "time-period-ranges",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/time-period-ranges",
  "version" : "1.0.0",
  "name" : "TimePeriodRanges",
  "title" : "Time Period Ranges",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-06-27",
  "publisher" : "HL7 International Clinical Quality Information Work Group",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org/Special/committees/cqi"
        }
      ]
    },
    {
      "telecom" : [
        {
          "system" : "email",
          "value" : "cqi@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "Defines codes for the representation of time period (e.g. age) ranges that are unambiguous, human readable, and machine-readable as a compositional grammar (i.e. the code system defines rules for constructing codes, rather than explicitly enumerating all possible codes). This CodeSystem profiles [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) for expressing time period ranges through two simple durations (as defined in the [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) specification).\n\nCodes in the code system are defined according to the grammar:\n\nA time period (e.g. age) range is defined as two durations: `[duration1]--[duration2]`, where `duration1` specifies the lower inclusive bound of the age range (everyone who is this age and above) and `duration2` specifies the upper exclusive bound of the age range.\n\nFor example, the age range \"1-9 years\" means everyone who is at least one year old and less than 10 years old represented as `P1Y--P10Y`. The age range \"10-14 years\" means everyone who is at least 10 years old and less than 15 years old and is represented as `P10Y--P15Y`.\n\nDurations define the amount of time between two time points. These durations are represented in the form `P[n]Y[n]M[n]DT[n]H[n]M[n]S` or `P[n]W`. The `[n]` is replaced by the value for each of the time elements that follow the `[n]` and the letters have the meaning:\n\n* `P` is the duration designator (for period) placed at the start of the duration representation.\n\t* `Y` is the year designator that follows the value for the number of years.\n\t* `M` is the month designator that follows the value for the number of months.\n\t* `W` is the week designator that follows the value for the number of weeks.\n\t* `D` is the day designator that follows the value for the number of days.\n* `T` is the time designator that precedes the time components of the representation.\n\t* `H` is the hour designator that follows the value for the number of hours.\n\t* `M` is the minute designator that follows the value for the number of minutes.\n\t* `S` is the second designator that follows the value for the number of seconds. (Note that seconds can be a decimal in this format to allow for milliseconds)\n\nFor example, `P3Y6M4DT12H30M5S` represents a duration of _three years, six months, four days, twelve hours, thirty minutes, and five seconds_.\n\nDate and time elements including their designator may be omitted if their value is zero, and lower-order elements may also be omitted for reduced precision. For example, `P23DT23H` and `P4Y` are both acceptable duration representations. However, at least one element must be present, thus `P` is not a valid representation for a duration of _0 seconds_. `PT0S` or `P0D`, however, are both valid and represent the same duration.\n\nNote that the designator `M` is used for both months and minutes, but this is not ambiguous because the minutes designator must be preceded by the time designator `T`. For example `P1M` is _one month_, while `PT1M` is _one minute_.\n\nContent for this code system is adapted from the definition in the IHE-ADX profile: https://www.ihe.net/uploadedFiles/Documents/QRPH/IHE_QRPH_Suppl_ADX.pdf (Appendix 8K Representation of Age Groups in ADX). In addition, the code system definition is adapted from similar content published as part of the SANER implementation guide. See [Age Range Coding System](https://hl7.org/fhir/uv/saner/CodeSystem-IHE-ADX-agerange.html).",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001"
        }
      ]
    }
  ],
  "purpose" : "This code system is defined to support consistent, unambiguous, human- and machine-readable representations of time period ranges. A primary intended use case is to support the specification of value sets of age ranges for the purposes of data stratification (also referred to as disaggregation).",
  "copyright" : "Adapted from content published by IHE Copyright (c) 2015 [IHE International, Inc](http://www.ihe.net/Governance/#Intellectual_Property). Used here according to the terms of the [CC BY 4 License](https://creativecommons.org/licenses/by/4.0/). This CodeSystem constitutes a profile on [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html), specifying use of its duration definitions for expressing time period ranges.",
  "_copyright" : {
    "extension" : [
      {
        "url" : "http://hl7.org/fhir/build/StructureDefinition/committee-notes",
        "valueString" : "Rationale: The use of ISO 8601 by particular communities of practice via profiles is encouraged in the specification (older version text posted here [8601-2](https://www.loc.gov/standards/datetime/iso-tc154-wg5_n0039_iso_wd_8601-2_2016-02-16.pdf)) and an example given via [EDTF.](https://en.wikipedia.org/wiki/ISO_8601) There are other prominent, well-used profiles published by other SDOs, including: [RFC 3339 (IETF)](https://www.rfc-editor.org/rfc/rfc3339) and [W3C date and time](https://www.w3.org/TR/NOTE-datetime)."
      }
    ]
  },
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/time-period-ranges",
  "compositional" : true,
  "content" : "not-present"
}

```
