# SupplyRequestReason - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **SupplyRequestReason**

## CodeSystem: SupplyRequestReason 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/supplyrequest-reason | *Version*:1.0.1 | | |
| Active as of 2024-04-24 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:SupplyRequestReason |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1193 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
The reason why the supply item was requested. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [SupplyRequestReason](ValueSet-supplyrequest-reason.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "supplyrequest-reason",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00"
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "oo"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/supplyrequest-reason",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1193"
    }
  ],
  "version" : "1.0.1",
  "name" : "SupplyRequestReason",
  "title" : "SupplyRequestReason",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-04-24T00:00:00+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "The reason why the supply item was requested.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/supplyrequest-reason",
  "content" : "complete",
  "concept" : [
    {
      "code" : "patient-care",
      "display" : "Patient Care",
      "definition" : "The supply has been requested for use in direct patient care."
    },
    {
      "code" : "ward-stock",
      "display" : "Ward Stock",
      "definition" : "The supply has been requested for creating or replenishing ward stock."
    }
  ]
}

```
