# SubscriptionChannel Type Codes - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **SubscriptionChannel Type Codes**

## CodeSystem: SubscriptionChannel Type Codes 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/subscription-channel-type | *Version*:1.0.1 | | |
| Active as of 2025-12-11 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 0 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:SubscriptionChannelTypeCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1432 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
The type of method used to execute a subscription 

 This Code system is referenced in the content logical definition of the following value sets: 

* [SubscriptionChannelTypeCodes](ValueSet-subscription-channel-type.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "subscription-channel-type",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fhir"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 0
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/subscription-channel-type",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1432"
    }
  ],
  "version" : "1.0.1",
  "name" : "SubscriptionChannelTypeCodes",
  "title" : "SubscriptionChannel Type Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-11T21:56:12-07:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "The type of method used to execute a subscription",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/subscription-channel-type",
  "content" : "complete",
  "concept" : [
    {
      "code" : "rest-hook",
      "display" : "Rest Hook",
      "definition" : "The channel is executed by making a POST to the URI with the selected payload and MIME type."
    },
    {
      "code" : "websocket",
      "display" : "Websocket",
      "definition" : "The channel is executed by sending a packet across a web socket connection maintained by the client. The URL identifies the websocket, and the client binds to this URL."
    },
    {
      "code" : "email",
      "display" : "Email",
      "definition" : "The channel is executed by sending an email to the email addressed in the URI (which must be a mailto:)."
    },
    {
      "code" : "message",
      "display" : "Message",
      "definition" : "The channel is executed by sending a message (e.g. a Bundle with a MessageHeader resource etc.) to the application identified in the URI."
    }
  ]
}

```
