# SpecialValues - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **SpecialValues**

## CodeSystem: SpecialValues 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/special-values | *Version*:1.0.0 | |
| Draft as of 2020-04-09 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:SpecialValues |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1049 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
A set of generally useful codes defined so they can be included in value sets. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [SpecialValues](ValueSet-special-values.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "special-values",
  "meta" : {
    "lastUpdated" : "2020-04-09T21:10:28.568+00:00"
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fhir"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/special-values",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1049"
    }
  ],
  "version" : "1.0.0",
  "name" : "SpecialValues",
  "title" : "SpecialValues",
  "status" : "draft",
  "experimental" : false,
  "date" : "2020-04-09T21:10:28+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "A set of generally useful codes defined so they can be included in value sets.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/special-values",
  "content" : "complete",
  "concept" : [
    {
      "code" : "true",
      "display" : "true",
      "definition" : "Boolean true."
    },
    {
      "code" : "false",
      "display" : "false",
      "definition" : "Boolean false."
    },
    {
      "code" : "trace",
      "display" : "Trace Amount Detected",
      "definition" : "The content is greater than zero, but too small to be quantified."
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/codesystem-concept-comments",
          "valueString" : "used in formulations (e.g. 'Add 10mg of ingredient X, 50mg of ingredient Y, and sufficient quantity of water to 100mL.' This code would be used to express the quantity of water. )"
        }
      ],
      "code" : "sufficient",
      "display" : "Sufficient Quantity",
      "definition" : "The specific quantity is not known, but is known to be non-zero and is not specified because it makes up the bulk of the material."
    },
    {
      "code" : "withdrawn",
      "display" : "Value Withdrawn",
      "definition" : "The value is no longer available."
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/codesystem-concept-comments",
          "valueString" : "The existence of this subject to review"
        }
      ],
      "code" : "nil-known",
      "display" : "Nil Known",
      "definition" : "The are no known applicable values in this context."
    }
  ]
}

```
