# ServiceProvisionConditions - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ServiceProvisionConditions**

## CodeSystem: ServiceProvisionConditions 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/service-provision-conditions | *Version*:1.0.1 | | |
| Active as of 2024-04-24 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ServiceProvisionConditions |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1143 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
The code(s) that detail the conditions under which the healthcare service is available/offered. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ServiceProvisionConditions](ValueSet-service-provision-conditions.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "service-provision-conditions",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00"
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pa"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/service-provision-conditions",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1143"
    }
  ],
  "version" : "1.0.1",
  "name" : "ServiceProvisionConditions",
  "title" : "ServiceProvisionConditions",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-04-24T00:00:00+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "The code(s) that detail the conditions under which the healthcare service is available/offered.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/service-provision-conditions",
  "content" : "complete",
  "concept" : [
    {
      "code" : "free",
      "display" : "Free",
      "definition" : "This service is available for no patient cost."
    },
    {
      "code" : "disc",
      "display" : "Discounts Available",
      "definition" : "There are discounts available on this service for qualifying patients."
    },
    {
      "code" : "cost",
      "display" : "Fees apply",
      "definition" : "Fees apply for this service."
    }
  ]
}

```
