# ResearchStudyPrimaryPurposeType - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ResearchStudyPrimaryPurposeType**

## CodeSystem: ResearchStudyPrimaryPurposeType 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/research-study-prim-purp-type | *Version*:1.0.0 | | |
| Draft as of 2020-04-09 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 0 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ResearchStudyPrimaryPurposeType |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1250 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | | |

 
Codes for the main intent of the study. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ResearchStudyPrimaryPurposeType](ValueSet-research-study-prim-purp-type.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "research-study-prim-purp-type",
  "meta" : {
    "lastUpdated" : "2020-04-09T21:10:28.568+00:00"
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "brr"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 0
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/research-study-prim-purp-type",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1250"
    }
  ],
  "version" : "1.0.0",
  "name" : "ResearchStudyPrimaryPurposeType",
  "title" : "ResearchStudyPrimaryPurposeType",
  "status" : "draft",
  "experimental" : false,
  "date" : "2020-04-09T21:10:28+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Codes for the main intent of the study.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/research-study-prim-purp-type",
  "content" : "complete",
  "concept" : [
    {
      "code" : "treatment",
      "display" : "Treatment",
      "definition" : "One or more interventions are being evaluated for treating a disease, syndrome, or condition."
    },
    {
      "code" : "prevention",
      "display" : "Prevention",
      "definition" : "One or more interventions are being assessed for preventing the development of a specific disease or health condition."
    },
    {
      "code" : "diagnostic",
      "display" : "Diagnostic",
      "definition" : "One or more interventions are being evaluated for identifying a disease or health condition."
    },
    {
      "code" : "supportive-care",
      "display" : "Supportive Care",
      "definition" : "One or more interventions are evaluated for maximizing comfort, minimizing side effects, or mitigating against a decline in the participant's health or function."
    },
    {
      "code" : "screening",
      "display" : "Screening",
      "definition" : "One or more interventions are assessed or examined for identifying a condition, or risk factors for a condition, in people who are not yet known to have the condition or risk factor."
    },
    {
      "code" : "health-services-research",
      "display" : "Health Services Research",
      "definition" : "One or more interventions for evaluating the delivery, processes, management, organization, or financing of healthcare."
    },
    {
      "code" : "basic-science",
      "display" : "Basic Science",
      "definition" : "One or more interventions for examining the basic mechanism of action (for example, physiology or biomechanics of an intervention)."
    },
    {
      "code" : "device-feasibility",
      "display" : "Device Feasibility",
      "definition" : "An intervention of a device product is being evaluated to determine the feasibility of the product or to test a prototype device and not health outcomes. Such studies are conducted to confirm the design and operating specifications of a device before beginning a full clinical trial."
    }
  ]
}

```
