# ResearchStudyPhase - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ResearchStudyPhase**

## CodeSystem: ResearchStudyPhase 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/research-study-phase | *Version*:1.0.0 | | |
| Active as of 2020-04-09 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ResearchStudyPhase |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1247 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | | |

 
Codes for the stage in the progression of a therapy from initial experimental use in humans in clinical trials to post-market evaluation. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ResearchStudyPhase](ValueSet-research-study-phase.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "research-study-phase",
  "meta" : {
    "lastUpdated" : "2020-04-09T21:10:28.568+00:00"
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "brr"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/research-study-phase",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1247"
    }
  ],
  "version" : "1.0.0",
  "name" : "ResearchStudyPhase",
  "title" : "ResearchStudyPhase",
  "status" : "active",
  "experimental" : false,
  "date" : "2020-04-09T21:10:28+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Codes for the stage in the progression of a therapy from initial experimental use in humans in clinical trials to post-market evaluation.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/research-study-phase",
  "content" : "complete",
  "concept" : [
    {
      "code" : "n-a",
      "display" : "N/A",
      "definition" : "Trials without phases (for example, studies of devices or behavioral interventions)."
    },
    {
      "code" : "early-phase-1",
      "display" : "Early Phase 1",
      "definition" : "Designation for optional exploratory trials conducted in accordance with the United States Food and Drug Administration's (FDA) 2006 Guidance on Exploratory Investigational New Drug (IND) Studies. Formerly called Phase 0."
    },
    {
      "code" : "phase-1",
      "display" : "Phase 1",
      "definition" : "Includes initial studies to determine the metabolism and pharmacologic actions of drugs in humans, the side effects associated with increasing doses, and to gain early evidence of effectiveness; may include healthy participants and/or patients."
    },
    {
      "code" : "phase-1-phase-2",
      "display" : "Phase 1/Phase 2",
      "definition" : "Trials that are a combination of phases 1 and 2."
    },
    {
      "code" : "phase-2",
      "display" : "Phase 2",
      "definition" : "Includes controlled clinical studies conducted to evaluate the effectiveness of the drug for a particular indication or indications in participants with the disease or condition under study and to determine the common short-term side effects and risks."
    },
    {
      "code" : "phase-2-phase-3",
      "display" : "Phase 2/Phase 3",
      "definition" : "Trials that are a combination of phases 2 and 3."
    },
    {
      "code" : "phase-3",
      "display" : "Phase 3",
      "definition" : "Includes trials conducted after preliminary evidence suggesting effectiveness of the drug has been obtained, and are intended to gather additional information to evaluate the overall benefit-risk relationship of the drug."
    },
    {
      "code" : "phase-4",
      "display" : "Phase 4",
      "definition" : "Studies of FDA-approved drugs to delineate additional information including the drug's risks, benefits, and optimal use."
    }
  ]
}

```
