# RejectionCriterion - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **RejectionCriterion**

## CodeSystem: RejectionCriterion 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/rejection-criteria | *Version*:1.0.1 | | |
| Active as of 2024-04-24 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:RejectionCriterion |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1260 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
Criterion for rejection of the specimen by laboratory. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [RejectionCriterion](ValueSet-rejection-criteria.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "rejection-criteria",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00"
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "oo"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/rejection-criteria",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1260"
    }
  ],
  "version" : "1.0.1",
  "name" : "RejectionCriterion",
  "title" : "RejectionCriterion",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-04-24T00:00:00+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Criterion for rejection of the specimen by laboratory.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/rejection-criteria",
  "content" : "complete",
  "concept" : [
    {
      "code" : "hemolized",
      "display" : "hemolized specimen",
      "definition" : "blood specimen hemolized."
    },
    {
      "code" : "insufficient",
      "display" : "insufficient specimen volume",
      "definition" : "insufficient quantity of specimen."
    },
    {
      "code" : "broken",
      "display" : "broken specimen container",
      "definition" : "specimen container broken."
    },
    {
      "code" : "clotted",
      "display" : "specimen clotted",
      "definition" : "specimen clotted."
    },
    {
      "code" : "wrong-temperature",
      "display" : "specimen temperature inappropriate",
      "definition" : "specimen temperature inappropriate."
    }
  ]
}

```
