# Procedure Type Codes - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Procedure Type Codes**

## CodeSystem: Procedure Type Codes 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/procedure-type | *Version*:1.0.0 | | |
| Active as of 2025-12-11 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ProcedureTypeCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.5.173 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
This value set includes Procedure Type codes. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ProcedureTypeCodes](ValueSet-procedure-type.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "procedure-type",
  "meta" : {
    "lastUpdated" : "2025-05-21T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/procedure-type",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.173"
    }
  ],
  "version" : "1.0.0",
  "name" : "ProcedureTypeCodes",
  "title" : "Procedure Type Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-11T21:56:12-07:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This value set includes Procedure Type codes.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/procedure-type",
  "content" : "complete",
  "concept" : [
    {
      "code" : "principal",
      "display" : "Principal procedure",
      "definition" : "The principal procedure is the procedure performed for definitive treatment most related to the principal diagnosis."
    },
    {
      "code" : "procedure-requiring-anesthesia",
      "display" : "Procedure requiring anesthesia",
      "definition" : "A procedure requiring anesthesia."
    }
  ]
}

```
