# Organization Affiliation Role - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Organization Affiliation Role**

## CodeSystem: Organization Affiliation Role 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/organization-affiliation-role | *Version*:1.0.0 | | |
| Active as of 2025-12-11 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:OrganizationAffiliationRole |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
This code system defines a set of codes that can be used to indicate an organization affiliation role. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [OrganizationAffiliationRole](ValueSet-organization-affiliation-role.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "organization-affiliation-role",
  "meta" : {
    "lastUpdated" : "2020-04-09T21:10:28.568+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pa"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/organization-affiliation-role",
  "version" : "1.0.0",
  "name" : "OrganizationAffiliationRole",
  "title" : "Organization Affiliation Role",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-11T21:56:12-07:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This code system defines a set of codes that can be used to indicate an organization affiliation role.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "content" : "complete",
  "concept" : [
    {
      "code" : "behavioral",
      "display" : "Outpatient Behavioral Health Provider",
      "definition" : "Provider of services related to the promotion of mental health, resilience and wellbeing; the treatment of mental and substance use 9.disorders; and the support of those who experience and/or are in recovery from these conditions, along with their families and communities."
    },
    {
      "code" : "bt",
      "display" : "Member Of",
      "definition" : "Has a relationship of participation with. This does NOT represent a member of an insurance plan, but other types of membership such as membership of a hospital in an HIE"
    },
    {
      "code" : "dme",
      "display" : "DME/Medical Supplier",
      "definition" : "Supplier of health care consumables or equipments supplied to patients."
    },
    {
      "code" : "group",
      "display" : "Medical Group",
      "definition" : "A group of people, e.g. a group of Physicians, who render health care services."
    },
    {
      "code" : "home",
      "display" : "Home Health Provider",
      "definition" : "Provider of health care services delivered to patients within their residence rather than a clinical setting; usually provided by nurses, home health aides, and other professionals on a regularly scheduled visit."
    },
    {
      "code" : "hospital",
      "display" : "Hospital",
      "definition" : "An inpatient facility, other than long-term care, providng patient treatment with specialzed medical and nursing staff and medical equipment."
    },
    {
      "code" : "laboratory",
      "display" : "Laboratory",
      "definition" : "Pathology and laboratory testing on clinical specimenst to obtain informaion about the health of a paeint to aid in diagnosis, treatment and prevention of disease."
    },
    {
      "code" : "outpatient",
      "display" : "Clinic or Outpatient Facility",
      "definition" : "An outpatient facility providing patient services, e.g. medical procedures, surgeries, etc."
    },
    {
      "code" : "pharmacy",
      "display" : "Pharmacy",
      "definition" : "An entity which provider services related to the storage, compounding, dispensing and sale of drugs."
    },
    {
      "code" : "transport",
      "display" : "Transporation Provider",
      "definition" : "A provider which transports patients to or from a medical facility, e.g., ambulance."
    },
    {
      "code" : "urgent",
      "display" : "Urgent Care Center",
      "definition" : "A center in which unscheduled health care services are provided for point-in-time evaluation or treatment of a non-life-threatening medical condition."
    },
    {
      "code" : "hospice",
      "display" : "Hospice",
      "definition" : "Hospice"
    },
    {
      "code" : "nurseCustodial",
      "display" : "Nursing and Custodial Care Facility",
      "definition" : "Nursing and Custodial Care Facility"
    },
    {
      "code" : "residential",
      "display" : "Residential Treatment Facility",
      "definition" : "Residential Treatment Facility"
    },
    {
      "code" : "respite",
      "display" : "Respite Care Facility",
      "definition" : "Respite Care Facility."
    },
    {
      "code" : "retail",
      "display" : "Retail Health Center",
      "definition" : "Retail Health Center"
    }
  ]
}

```
