# MedicationKnowledge Characteristic Codes - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **MedicationKnowledge Characteristic Codes**

## CodeSystem: MedicationKnowledge Characteristic Codes 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/medicationknowledge-characteristic | *Version*:1.0.1 | | |
| Active as of 2025-12-11 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:MedicationKnowledgeCharacteristicCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1338 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
MedicationKnowledge Characteristic Codes 

 This Code system is referenced in the content logical definition of the following value sets: 

* [MedicationKnowledgeCharacteristicCodes](ValueSet-medicationknowledge-characteristic.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "medicationknowledge-characteristic",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "phx"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/medicationknowledge-characteristic",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1338"
    }
  ],
  "version" : "1.0.1",
  "name" : "MedicationKnowledgeCharacteristicCodes",
  "title" : "MedicationKnowledge Characteristic Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-11T21:56:12-07:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "MedicationKnowledge Characteristic Codes",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/medicationknowledge-characteristic",
  "content" : "complete",
  "concept" : [
    {
      "code" : "imprintcd",
      "display" : "Imprint Code",
      "definition" : "Identyifying marks on product"
    },
    {
      "code" : "size",
      "display" : "Size",
      "definition" : "Description of size of the product"
    },
    {
      "code" : "shape",
      "display" : "Shape",
      "definition" : "Description of the shape of the product"
    },
    {
      "code" : "color",
      "display" : "Color",
      "definition" : "Description of the color of the product"
    },
    {
      "code" : "coating",
      "display" : "Coating",
      "definition" : "Description of the coating of the product"
    },
    {
      "code" : "scoring",
      "display" : "Scoring",
      "definition" : "Description of the scoring of the product"
    },
    {
      "code" : "logo",
      "display" : "Logo",
      "definition" : "Description of the Logo of the product"
    },
    {
      "code" : "image",
      "display" : "Image",
      "definition" : "Description of the Image of the product"
    }
  ]
}

```
