# List Empty Reasons - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **List Empty Reasons**

## CodeSystem: List Empty Reasons 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/list-empty-reason | *Version*:1.0.1 | |
| Active as of 2025-12-11 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ListEmptyReasons |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1106 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | |

 
General reasons for a list to be empty. Reasons are either related to a summary list (i.e. problem or medication list) or to a workflow related list (i.e. consultation list). 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ListEmptyReasons](ValueSet-list-empty-reason.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "list-empty-reason",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "sd"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/list-empty-reason",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1106"
    }
  ],
  "version" : "1.0.1",
  "name" : "ListEmptyReasons",
  "title" : "List Empty Reasons",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-11T21:56:12-07:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "General reasons for a list to be empty. Reasons are either related to a summary list (i.e. problem or medication list) or to a workflow related list (i.e. consultation list).",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/list-empty-reason",
  "content" : "complete",
  "concept" : [
    {
      "code" : "nilknown",
      "display" : "Nil Known",
      "definition" : "Clinical judgment that there are no known items for this list after reasonable investigation. Note that this a positive statement by a clinical user, and not a default position asserted by a computer system in the lack of other information. Example uses:  * For allergies: the patient or patient's agent/guardian has asserted that he/she is not aware of any allergies (NKA - nil known allergies)  * For medications: the patient or patient's agent/guardian has asserted that the patient is known to be taking no medications  * For diagnoses, problems and procedures: the patient or patient's agent/guardian has asserted that there is no known event to record."
    },
    {
      "code" : "notasked",
      "display" : "Not Asked",
      "definition" : "The investigation to find out whether there are items for this list has not occurred."
    },
    {
      "code" : "withheld",
      "display" : "Information Withheld",
      "definition" : "The content of the list was not provided due to privacy or confidentiality concerns. Note that it should not be assumed that this means that the particular information in question was withheld due to its contents - it can also be a policy decision."
    },
    {
      "code" : "unavailable",
      "display" : "Unavailable",
      "definition" : "Information to populate this list cannot be obtained; e.g. unconscious patient."
    },
    {
      "code" : "notstarted",
      "display" : "Not Started",
      "definition" : "The work to populate this list has not yet begun."
    },
    {
      "code" : "closed",
      "display" : "Closed",
      "definition" : "This list has now closed or has ceased to be relevant or useful."
    }
  ]
}

```
