# Insurance Product Type - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Insurance Product Type**

## CodeSystem: Insurance Product Type 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/insurance-product-type | *Version*:1.0.0 | | |
| Active as of 2025-12-11 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:InsuranceProductType |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
This code system defines a set of codes for Insurance Product Type. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [InsuranceProductType](ValueSet-insurance-product-type.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "insurance-product-type",
  "meta" : {
    "lastUpdated" : "2020-04-09T21:10:28.568+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pa"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/insurance-product-type",
  "version" : "1.0.0",
  "name" : "InsuranceProductType",
  "title" : "Insurance Product Type",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-11T21:56:12-07:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This code system defines a set of codes for Insurance Product Type.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/insurance-product-type",
  "content" : "complete",
  "concept" : [
    {
      "code" : "commppo",
      "display" : "Commercial PPO",
      "definition" : "Health insurance provided through a Preferred Provider Organization (PPO)."
    },
    {
      "code" : "commhdhp",
      "display" : "Commercial HDHP",
      "definition" : "Health insurance provided through a High Deductible Health Plan (HDHP)."
    },
    {
      "code" : "commpos",
      "display" : "Commercial POS",
      "definition" : "Health insurance provided through a Point-of-Service (POS) Plan."
    },
    {
      "code" : "commhmo",
      "display" : "Commercial HMO",
      "definition" : "Health insurance provided through a Health Maintenance Organization (HMO)."
    },
    {
      "code" : "commepo",
      "display" : "Commercial EPO",
      "definition" : "Health insurance provided through a Exclusive Provider Organization(EPO)"
    },
    {
      "code" : "medi",
      "display" : "Medicaid",
      "definition" : "Health insurance provided to eligible adults and children under the Federal Medicaid program"
    },
    {
      "code" : "medihmo",
      "display" : "Medicaid HMO",
      "definition" : "Health insurance provided to eligible adults and children under the Federal Medicaid program through a Health Maintenance Organization (HMO)."
    },
    {
      "code" : "mediadv",
      "display" : "Medicare Advantage",
      "definition" : "Health insurance provided by a private company that contracts with Medicare to provide all Medicare Part A and Part B benefits."
    },
    {
      "code" : "mediadvhmo",
      "display" : "Medicare Advantage HMO",
      "definition" : "Health insurance offered by a private company that contracts with Medicare to provide all Medicare Part A and Part B benefits through a Health Maintenance Organization (HMO)."
    },
    {
      "code" : "media",
      "display" : "Medicare Part A",
      "definition" : "Health insurance provided under the Federal Medicare program covering inpatient hospital stays, care in a skilled nursing facility, hospice care, and some home health care."
    },
    {
      "code" : "medib",
      "display" : "Medicare Part B",
      "definition" : "Health insurance provided under the Federal Medicfare program covering certain doctors' services, outpatient care, medical supplies, and preventive services."
    },
    {
      "code" : "medid",
      "display" : "Medicare Part D",
      "definition" : "Health insurance provided under the Federal Medicare program covering prescription drugs."
    },
    {
      "code" : "mediab",
      "display" : "Medicare A/B",
      "definition" : "Health insurance provided under the Federal Medicare program covering inpatient hospital stays, care in a skilled nursing facility, hospice care, some home health care, certain doctors' services, outpatient care, medical supplies, and preventive services."
    },
    {
      "code" : "qhp",
      "display" : "Qualified Health Plan",
      "definition" : "Health insurance provided through and certified by the Health Insurance Marketplace that provides essential health benefits (EHBs), follows established limits on cost sharing, and meets other requirements outlined within the application process."
    },
    {
      "code" : "ihs",
      "display" : "Indian Health Service",
      "definition" : "Health care program provided to United States American Indians and Alaska Natives."
    },
    {
      "code" : "fep",
      "display" : "Federal Employee Program",
      "definition" : "Health insurance provided to employees of the Federal government."
    },
    {
      "code" : "tri",
      "display" : "TRICARE",
      "definition" : "Health care program provided to uniformed service members, retirees, and their families around the world."
    },
    {
      "code" : "va",
      "display" : "Veterans Affairs Plan",
      "definition" : "Health care program provided to eligible veterans."
    },
    {
      "code" : "dent",
      "display" : "Dental Plan",
      "definition" : "Health insurance provided to cover services related to the study, diagnosis, prevention, and treatment of diseases, disorders, and conditions of the oral cavity."
    },
    {
      "code" : "denthmo",
      "display" : "Dental HMO",
      "definition" : "Health insurance provided to cover services related to the study, diagnosis, prevention, and treatment of diseases, disorders, and conditions of the oral cavity provided through a Health Maintenance Organization (HMO)."
    },
    {
      "code" : "vis",
      "display" : "Vision Plan",
      "definition" : "Health insurance provided to cover services related to the study, diagnosis, prevention, and treatment of diseases, disorders, and conditions of the eyes."
    },
    {
      "code" : "vishmo",
      "display" : "Vision HMO",
      "definition" : "Health insurance provided to cover services related to the study, diagnosis, prevention, and treatment of diseases, disorders, and conditions of the eyes provided through a Health Maintenance Organization (HMO)."
    }
  ]
}

```
