# Immunization Subpotent Reason - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Immunization Subpotent Reason**

## CodeSystem: Immunization Subpotent Reason 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/immunization-subpotent-reason | *Version*:1.0.1 | | |
| Active as of 2025-12-11 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ImmunizationSubpotentReason |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1098 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
The value set to instantiate this attribute should be drawn from a terminologically robust code system that consists of or contains concepts to support describing the reason why a dose is considered to be subpotent. This value set is provided as a suggestive example. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ImmunizationSubpotentReason](ValueSet-immunization-subpotent-reason.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "immunization-subpotent-reason",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pher"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/immunization-subpotent-reason",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1098"
    }
  ],
  "version" : "1.0.1",
  "name" : "ImmunizationSubpotentReason",
  "title" : "Immunization Subpotent Reason",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-11T21:56:12-07:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "The value set to instantiate this attribute should be drawn from a terminologically robust code system that consists of or contains concepts to support describing the reason why a dose is considered to be subpotent. This value set is provided as a suggestive example.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/immunization-subpotent-reason",
  "content" : "complete",
  "concept" : [
    {
      "code" : "partialdose",
      "display" : "Partial Dose",
      "definition" : "The full volume of the dose was not administered to the patient."
    },
    {
      "code" : "coldchainbreak",
      "display" : "Cold Chain Break",
      "definition" : "The vaccine experienced a cold chain break."
    },
    {
      "code" : "recall",
      "display" : "Manufacturer Recall",
      "definition" : "The vaccine was recalled by the manufacturer."
    },
    {
      "code" : "adversestorage",
      "display" : "Adverse Storage",
      "definition" : "The vaccine experienced adverse storage conditions."
    },
    {
      "code" : "expired",
      "display" : "Expired Product",
      "definition" : "The vaccine was expired at the time of administration."
    }
  ]
}

```
