# Group Code - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Group Code**

## CodeSystem: Group Code 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/group-code | *Version*:1.0.0 | | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R5/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[HL7 (FHIR Project)](http://hl7.org/fhir) | *Computable Name*:GroupCode |

 
A code that describes the use of the group. The use of the group usually dictates what kind of entities can be members of the group. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [GroupCode](ValueSet-group-code.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "group-code",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fhir"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/group-code",
  "version" : "1.0.0",
  "name" : "GroupCode",
  "title" : "Group Code",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-10-11",
  "publisher" : "HL7 (FHIR Project)",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org/fhir"
        },
        {
          "system" : "email",
          "value" : "fhir@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "A code that describes the use of the group. The use of the group usually dictates what kind of entities can be members of the group.",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/group-code",
  "content" : "complete",
  "concept" : [
    {
      "code" : "patient-list",
      "display" : "Patient-List",
      "definition" : "A list of patients for the purpose of some kind of clinical treatment."
    },
    {
      "code" : "family",
      "display" : "Family",
      "definition" : "A group of persons and/or animals that constitute a family. The definition of family is not precisely fixed and subject to much variableness in interpretation."
    },
    {
      "code" : "household",
      "display" : "Household",
      "definition" : "A group of persons and/or animals that reside in a singe house. Both the definitions of 'reside' and 'house' are not precisely fixed."
    },
    {
      "code" : "workplace",
      "display" : "Workplace",
      "definition" : "A group of persons who work together in a single place."
    },
    {
      "code" : "event-attendee",
      "display" : "Event Attendee",
      "definition" : "Group contains a set of persons and/or animals who were at the same place at the same time. This is typically used for an infection event"
    },
    {
      "code" : "exposure-group",
      "display" : "Exposure Group",
      "definition" : "Group contains a set of persons and/or animals who were exposed to some antigen or infectious agent."
    },
    {
      "code" : "herd",
      "display" : "Herd",
      "definition" : "Group contains a set of animals that are treated as a coherent group."
    },
    {
      "code" : "locality",
      "display" : "Locality",
      "definition" : "Group contains HealthcareService resources that are found in a single geographical location."
    },
    {
      "code" : "organization",
      "display" : "Organization",
      "definition" : "A collection of healthcare services."
    },
    {
      "code" : "collection",
      "display" : "Collection",
      "definition" : "A collection of entities for an arbitrary reason."
    }
  ]
}

```
